/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.ktiml.plan.planning4jconnector;

import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.impl.AbstractAsyncPlanner;
import cz.cuni.amis.planning4j.impl.PlanFuture;
import cz.cuni.amis.planning4j.pddl.PDDLAction;
import cz.cuni.amis.planning4j.pddl.PDDLDomain;
import cz.cuni.amis.planning4j.pddl.PDDLPredicate;
import cz.cuni.amis.planning4j.pddl.PDDLProblem;
import cz.cuni.amis.planning4j.pddl.PDDLSimpleAction;
import cz.cuni.ktiml.plan.planning4jconnector.ActionInstancePlanningResult;
import cz.mff.ktiml.plan.heuristics.MetaHeuristic;
import cz.mff.ktiml.plan.heuristics.RelaxedPlanningProblem;
import cz.mff.ktiml.plan.heuristics.landmarkcut.LandMarkCut;
import cz.mff.ktiml.plan.translation.entities.ActionInstance;
import cz.mff.ktiml.plan.translation.entities.SAtom;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public class ANAPlanner
extends AbstractAsyncPlanner {
    private static final Object singleThreadMutex = new Object();
    protected long timeLimit;

    public ANAPlanner(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    protected RelaxedPlanningProblem createRelaxedPlanningProblem(IDomainProvider domainProvider, IProblemProvider problemProvider) {
        LinkedHashSet<SAtom> problemAtoms = new LinkedHashSet<SAtom>();
        LinkedList<ActionInstance> problemActions = new LinkedList<ActionInstance>();
        PDDLDomain domain = domainProvider.getDomainAsPDDL();
        if (domain == null) {
            throw new PlanningException("Given domain does not support getDomainAsPDDL()");
        }
        PDDLProblem problem = problemProvider.getProblemAsPDDL();
        if (problem == null) {
            throw new PlanningException("Given problem does not support getProblemAsPDDL()");
        }
        for (PDDLPredicate predicate : domain.getPredicates()) {
            if (!predicate.getParameters().isEmpty()) {
                throw new PlanningException("Only ground predicates and actions are supported");
            }
            SAtom predicateAtom = new SAtom(new ArrayList(), false, predicate.getName());
            problemAtoms.add(predicateAtom);
        }
        for (PDDLAction action : domain.getActions()) {
            SAtom at;
            if (!action.getParameters().isEmpty()) {
                throw new PlanningException("Only ground predicates and actions are supported");
            }
            if (!(action instanceof PDDLSimpleAction)) {
                throw new PlanningException("Only PDDLSimpleActions are currently supported");
            }
            PDDLSimpleAction simpleAction = (PDDLSimpleAction)action;
            if (!simpleAction.getNegativeEffects().isEmpty()) {
                throw new PlanningException("Negative effects are not supported");
            }
            ArrayList<SAtom> pre = new ArrayList<SAtom>();
            ArrayList<SAtom> eff = new ArrayList<SAtom>();
            for (String precondition : simpleAction.getPreconditionList()) {
                at = new SAtom(new ArrayList(), false, precondition);
                pre.add(at);
            }
            for (String effect : simpleAction.getPositiveEffects()) {
                at = new SAtom(new ArrayList(), false, effect);
                eff.add(at);
            }
            problemActions.add(new ActionInstance(simpleAction.getName(), pre, eff));
        }
        LinkedList<SAtom> init = new LinkedList<SAtom>();
        LinkedList<SAtom> goal = new LinkedList<SAtom>();
        for (String initialLiteral : problem.getInitialLiterals()) {
            init.add(new SAtom(new ArrayList(), false, initialLiteral));
        }
        for (String goalLiteral : problem.getGoalConditions()) {
            goal.add(new SAtom(new ArrayList(), false, goalLiteral));
        }
        RelaxedPlanningProblem rpp = new RelaxedPlanningProblem(problemAtoms, init, goal, problemActions);
        return rpp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPlanFuture planAsync(IDomainProvider domainProvider, IProblemProvider problemProvider) {
        Object object = singleThreadMutex;
        synchronized (object) {
            SAtom.Init();
            ActionInstance.ResetPooling();
            RelaxedPlanningProblem problem = this.createRelaxedPlanningProblem(domainProvider, problemProvider);
            ANAPlanFuture planFuture = new ANAPlanFuture(problem);
            ANAComputationProcess process = new ANAComputationProcess(problem, planFuture);
            new Thread((Runnable)process, "ANAPlanner").start();
            return planFuture;
        }
    }

    protected class ANAPlanFuture
    extends PlanFuture<IPlanningResult> {
        RelaxedPlanningProblem problem;

        public ANAPlanFuture(RelaxedPlanningProblem problem) {
            this.problem = problem;
        }

        protected boolean cancelComputation(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.problem.cancelComputation();
                return true;
            }
            return super.cancelComputation(mayInterruptIfRunning);
        }
    }

    protected class ANAComputationProcess
    implements Runnable {
        RelaxedPlanningProblem problem;
        private PlanFuture planFuture;

        public ANAComputationProcess(RelaxedPlanningProblem problem, PlanFuture planFuture) {
            this.problem = problem;
            this.planFuture = planFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = singleThreadMutex;
            synchronized (object) {
                try {
                    LinkedList result = this.problem.SolveANA(new MetaHeuristic[]{new LandMarkCut()}, ANAPlanner.this.timeLimit);
                    if (!this.planFuture.isCancelled()) {
                        this.planFuture.setResult((Object)new ActionInstancePlanningResult(result));
                    }
                }
                catch (RuntimeException ex) {
                    this.planFuture.computationException((Exception)ex);
                }
            }
        }
    }
}

