/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class VariableContext {
    private VariableContext parent;
    private Map<String, Object> vars = new HashMap<String, Object>();

    public VariableContext() {
        this.parent = null;
    }

    public VariableContext(VariableContext ctx, Arguments callArgs) {
        this.parent = ctx;
        for (Arguments.Argument param : callArgs) {
            String argumentVariable = param.getParameterVariable();
            if (argumentVariable != null) {
                this.vars.put(param.getName(), ctx.getValue(argumentVariable));
                continue;
            }
            this.vars.put(param.getName(), param.getValue());
        }
    }

    public VariableContext(VariableContext ctx, Arguments callParameters, FormalParameters formalParameters) {
        this.parent = ctx;
        HashSet<Arguments.Argument> unusedArgs = new HashSet<Arguments.Argument>(callParameters);
        for (int index = 0; index < formalParameters.size(); ++index) {
            String ctxVariableName = formalParameters.get(index).getName();
            Object ctxVariableValue = formalParameters.get(index).getDefaultValue();
            for (Arguments.Argument param : callParameters) {
                block8: {
                    String argumentName = param.getName();
                    try {
                        int paramterIndex = Integer.parseInt(argumentName);
                        if (index != paramterIndex) {
                        }
                        break block8;
                    }
                    catch (NumberFormatException ex) {
                        String parameterName = param.getName();
                        if (parameterName.equals(ctxVariableName)) break block8;
                    }
                    continue;
                }
                unusedArgs.remove(param);
                String variableName = param.getParameterVariable();
                if (variableName != null) {
                    ctxVariableValue = ctx.getValue(variableName);
                    continue;
                }
                ctxVariableValue = param.getValue();
            }
            this.vars.put(ctxVariableName, ctxVariableValue);
        }
        for (Arguments.Argument unusedArg : unusedArgs) {
            String variableName = unusedArg.getParameterVariable();
            if (variableName != null) {
                if (!ctx.hasVariable(variableName)) continue;
                this.vars.put(unusedArg.getName(), ctx.getValue(variableName));
                continue;
            }
            this.vars.put(unusedArg.getName(), unusedArg.getValue());
        }
    }

    public synchronized Object put(String parameterName, Object value) {
        return this.vars.put(parameterName, value);
    }

    public synchronized String[] getKeys() {
        HashSet<String> allKeys = new HashSet<String>();
        VariableContext currentCtx = this;
        while (currentCtx != null) {
            allKeys.addAll(currentCtx.vars.keySet());
            currentCtx = currentCtx.parent;
        }
        return allKeys.toArray(new String[allKeys.size()]);
    }

    public synchronized Object getValue(String variableName) {
        if (this.vars.containsKey(variableName)) {
            return this.vars.get(variableName);
        }
        if (this.parent != null) {
            return this.parent.getValue(variableName);
        }
        throw new IllegalArgumentException("There is no variable in the context with name \"" + variableName + "\".");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Object[] list = new String[this.vars.size()];
        int index = 0;
        for (Map.Entry<String, Object> entry : this.vars.entrySet()) {
            list[index++] = entry.getKey() + "=" + Result.toLap(entry.getValue());
        }
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append((String)list[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public synchronized int size() {
        return this.vars.size();
    }

    public boolean hasVariable(String variableName) {
        if (this.vars.containsKey(variableName)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasVariable(variableName);
        }
        return false;
    }
}

