/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.util.AbstractList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class Trigger<OWNER extends PoshElement>
extends AbstractList<Sense> {
    private final List<Sense> senses = new LinkedList<Sense>();
    private final List<Sense> sensesUm = Collections.unmodifiableList(this.senses);
    private final OWNER owner;

    Trigger(OWNER owner, List<Sense> senses) {
        this.owner = owner;
        for (Sense sense : senses) {
            assert (sense.getParent() == null);
            this.add(sense);
        }
    }

    Trigger(OWNER owner) {
        this(owner, Collections.emptyList());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (Sense sense : this.sensesUm) {
            if (first) {
                first = false;
                sb.append(sense.toString());
                continue;
            }
            sb.append(' ');
            sb.append(sense.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean add(Sense sense) {
        assert (!this.contains(sense));
        assert (!sense.isChildOfParent());
        sense.setParent(this.owner);
        boolean ret = this.senses.add(sense);
        ((PoshElement)this.owner).emitChildNode(sense);
        return ret;
    }

    @Override
    public Sense get(int index) {
        return this.senses.get(index);
    }

    @Override
    public void add(int index, Sense newSense) {
        assert (!this.contains(newSense));
        assert (!newSense.isChildOfParent());
        newSense.setParent(this.owner);
        this.senses.add(index, newSense);
        ((PoshElement)this.owner).emitChildNode(newSense);
    }

    @Override
    public Sense remove(int index) {
        Sense sense = this.senses.remove(index);
        sense.setParent(null);
        ((PoshElement)this.owner).emitChildDeleted(sense, index);
        return sense;
    }

    @Override
    public int size() {
        return this.senses.size();
    }

    List<Sense> unmodifiable() {
        return this.sensesUm;
    }

    public void moveSense(int newIndex, Sense movedSense) {
        assert (this.sensesUm.contains(movedSense));
        assert (movedSense.getTrigger() == this);
        int originalIndex = this.sensesUm.indexOf(movedSense);
        if (newIndex > originalIndex) {
            Sense removed = this.senses.remove(originalIndex);
            this.senses.add(newIndex, movedSense);
        } else if (newIndex < originalIndex) {
            this.senses.remove(originalIndex);
            this.senses.add(newIndex, movedSense);
        } else {
            return;
        }
        ((PoshElement)this.owner).emitChildMove(movedSense, originalIndex, newIndex);
    }
}

