/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.awt.datatransfer.DataFlavor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActionPattern
extends PoshDummyElement<ActionPattern, PoshPlan>
implements IParametrizedElement {
    private String name;
    @Deprecated
    private String comment;
    private final List<TriggeredAction> actions = new ArrayList<TriggeredAction>();
    private final List<TriggeredAction> actionsUm = Collections.unmodifiableList(this.actions);
    protected FormalParameters params;
    public static final String apName = "apName";
    public static final String apComment = "apComment";
    public static final String apParams = "apParams";
    public static final DataFlavor dataFlavor = new DataFlavor(ActionPattern.class, "action-pattern-node");

    ActionPattern(String name, FormalParameters params, List<TriggeredAction> ap, String comment) {
        assert (name != null);
        assert (params != null);
        assert (comment != null);
        this.name = name;
        this.params = params;
        this.comment = comment;
        for (TriggeredAction action : ap) {
            assert (action.getParent() == null);
            action.setParent(this);
            this.actions.add(action);
        }
    }

    public void addAction(TriggeredAction action) throws CycleException {
        int beyondLastActionIndex = this.actionsUm.size();
        this.addAction(beyondLastActionIndex, action);
    }

    public void addAction(int index, TriggeredAction action) throws CycleException {
        assert (!action.isChildOfParent());
        action.setParent(this);
        this.actions.add(index, action);
        PoshPlan root = this.getRootNode();
        if (root != null && root.isCycled()) {
            this.actions.remove(action);
            throw CycleException.createFromName(action.getName());
        }
        this.emitChildNode(action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\t(AP ");
        sb.append(this.name);
        if (!this.params.isEmpty()) {
            sb.append(" vars(");
            sb.append(this.params.toString());
            sb.append(")");
        }
        sb.append(" (");
        boolean firstAction = true;
        for (TriggeredAction action : this.actionsUm) {
            if (!firstAction) {
                sb.append(' ');
            } else {
                firstAction = false;
            }
            sb.append(action.toString());
        }
        sb.append(')');
        if (!this.comment.isEmpty()) {
            sb.append(" \"");
            sb.append(this.comment);
            sb.append('\"');
        }
        sb.append(")\n");
        return sb.toString();
    }

    @Override
    public List<TriggeredAction> getChildDataNodes() {
        return this.actionsUm;
    }

    public void setName(String name) throws InvalidNameException, DuplicateNameException, CycleException {
        if (!(name = name.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw InvalidNameException.create(name);
        }
        if (!this.getName().equals(name) && this.getRootNode() != null && !this.getRootNode().isUniqueNodeName(name)) {
            throw DuplicateNameException.create(name);
        }
        String oldName = this.name;
        this.name = name;
        if (this.getRootNode() != null && this.getRootNode().isCycled()) {
            this.name = oldName;
            throw CycleException.createFromName(name);
        }
        this.firePropertyChange(apName, oldName, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getHtmlDescription() {
        return "<html>Action pattern: " + this.getName() + "<br/><pre>" + this.toString() + "</pre></html>";
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        assert (child instanceof TriggeredAction);
        return this.moveChildInList(this.actions, (TriggeredAction)child, newIndex);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public LapType getType() {
        return LapType.ACTION_PATTERN;
    }

    public void removeAction(TriggeredAction action) {
        assert (this.actions.contains(action));
        if (this.actions.size() == 1) {
            try {
                this.addAction(LapElementsFactory.createAction());
            }
            catch (CycleException ex) {
                String msg = MessageFormat.format("Adding an action with default name {0} causes a cycle.", LapElementsFactory.DEFAULT_ACTION);
                Logger.getLogger(ActionPattern.class.getName()).log(Level.SEVERE, msg, ex);
                throw new FubarException(msg, ex);
            }
        }
        int removedActionPosition = this.actionsUm.indexOf(action);
        this.actions.remove(action);
        action.setParent(null);
        this.emitChildDeleted(action, removedActionPosition);
    }

    public List<TriggeredAction> getActions() {
        return this.actionsUm;
    }

    @Override
    public FormalParameters getParameters() {
        return this.params;
    }

    @Deprecated
    String getComment() {
        return this.comment;
    }

    @Deprecated
    void setComment(String newComment) {
        assert (newComment != null);
        String oldComment = this.comment;
        this.comment = newComment;
        this.firePropertyChange(apComment, oldComment, newComment);
    }

    @Override
    public void setParameters(FormalParameters newParams) {
        FormalParameters oldParams = this.params;
        this.params = newParams;
        this.firePropertyChange(apParams, oldParams, newParams);
    }

    @Override
    public void rename(String newAPName) throws InvalidNameException, DuplicateNameException, CycleException {
        PoshPlan plan = this.getRootNode();
        if (plan == null) {
            throw new IllegalStateException("AP " + this.getName() + " is not part of a plan.");
        }
        List<TriggeredAction> planReferences = plan.getAllReferences();
        LinkedList<TriggeredAction> referencingActions = new LinkedList<TriggeredAction>();
        for (TriggeredAction planAction : planReferences) {
            boolean actionReferencesAP = planAction.getName().equals(this.getName());
            if (!actionReferencesAP) continue;
            referencingActions.add(planAction);
        }
        for (TriggeredAction referencingAction : referencingActions) {
            referencingAction.setActionName(newAPName);
        }
        this.setName(newAPName);
    }

    public TriggeredAction getAction(int actionId) {
        return this.actionsUm.get(actionId);
    }
}

