/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite.rewriter;

import cz.cuni.amis.utils.rewrite.rewriter.Const;
import cz.cuni.amis.utils.rewrite.rewriter.ISubstitution;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class Rewriter {
    private static String NEW_LINE = System.getProperty("line.separator");
    private List<ISubstitution> substitutions;
    private Logger log = null;

    public Rewriter() {
        this.substitutions = new ArrayList<ISubstitution>();
    }

    public Rewriter(List<? extends ISubstitution> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException("'substitutions' can't be null!");
        }
        this.substitutions = substitutions;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public List<ISubstitution> getISubstitutions() {
        return this.substitutions;
    }

    public boolean hasMultiLineISubstitution() {
        for (ISubstitution subst : this.substitutions) {
            if (!subst.isMultiLine()) continue;
            return true;
        }
        return false;
    }

    public Rewriter addISubstitution(ISubstitution subst) {
        if (subst == null) {
            return this;
        }
        this.substitutions.add(subst);
        return this;
    }

    public synchronized String rewrite(String text, boolean multiLine) {
        if (this.substitutions.size() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        String result = text;
        if (multiLine) {
            for (ISubstitution subst : this.substitutions) {
                if (subst.isMultiLine()) {
                    result = subst.substitute(result);
                    continue;
                }
                String processing = result;
                StringBuffer sb = new StringBuffer();
                int index = 0;
                while (index < processing.length()) {
                    String part;
                    int newLineIndex = processing.indexOf("\n", index);
                    if (newLineIndex < 0) {
                        part = processing.substring(index);
                        sb.append(subst.substitute(part));
                        index = processing.length();
                        continue;
                    }
                    part = null;
                    part = newLineIndex == 0 || processing.charAt(newLineIndex - 1) != '\r' ? processing.substring(index, newLineIndex) : processing.substring(index, newLineIndex - 1);
                    sb.append(subst.substitute(part));
                    index = newLineIndex + 1;
                    sb.append(NEW_LINE);
                }
            }
        } else {
            for (ISubstitution subst : this.substitutions) {
                if (subst.isMultiLine()) {
                    throw new RuntimeException("Rewriter.rewrite() called with multiLine == false, but it was configured with multi-line substitution! Invalid!");
                }
                result = subst.substitute(result);
            }
        }
        return result;
    }

    public synchronized boolean rewriteFile(File input, File output) throws IOException {
        int lineNumber = 1;
        boolean changed = false;
        if (this.hasMultiLineISubstitution()) {
            this.log.warning("Multi-line substitution(s) detected, buffering whole file into the memory.");
            String file = FileUtils.readFileToString((File)input);
            String rewritten = this.rewrite(file, true);
            if (!file.equals(rewritten)) {
                this.log.info("Some substitutions were applied.");
                changed = true;
            }
            PrintWriter writer = new PrintWriter(new FileWriter(output));
            try {
                writer.print(rewritten);
            }
            finally {
                writer.close();
            }
        }
        this.log.info("No multi-line patterns present, rewriting file line-by-line (as if streaming).");
        BufferedReader reader = new BufferedReader(new FileReader(input));
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(output));
            try {
                while (reader.ready()) {
                    String rewritten;
                    String line = reader.readLine();
                    if (!line.equals(rewritten = this.rewrite(line, false))) {
                        changed = true;
                        if (this.log != null) {
                            this.log.info("Replacing[" + lineNumber + "]" + ": " + line.trim() + Const.NEW_LINE + "       With:        " + Const.whitespaces(String.valueOf(lineNumber).length()) + rewritten.trim());
                        }
                    }
                    writer.println(rewritten);
                    ++lineNumber;
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
        return changed;
    }

    public synchronized boolean rewriteFile(File file) throws IOException {
        File tempFile = new File("temp.rewrite.txt");
        if (this.rewriteFile(file, tempFile)) {
            file.delete();
            FileUtils.moveFile((File)tempFile, (File)file);
            tempFile.delete();
            return true;
        }
        tempFile.delete();
        return false;
    }
}

