/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.utils.rewrite.MyDirectoryWalker;
import cz.cuni.amis.utils.rewrite.RewriteUtils;
import cz.cuni.amis.utils.rewrite.rewriter.Const;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;

@XStreamAlias(value="includeDir")
public class IncludeDir {
    @XStreamAlias(value="dir")
    @XStreamAsAttribute
    private File dir;
    @XStreamAlias(value="subdirs")
    @XStreamAsAttribute
    private Boolean subdirs = true;
    @XStreamImplicit(itemFieldName="excludeDir")
    private List<String> excludeDirs = new ArrayList<String>();
    @XStreamImplicit(itemFieldName="includeFile")
    private List<String> includeFiles = new ArrayList<String>();
    @XStreamImplicit(itemFieldName="excludeFile")
    private List<String> excludeFiles = new ArrayList<String>();
    @XStreamOmitField
    private MyDirectoryWalker directoryWalker;
    @XStreamOmitField
    private transient WildcardFileFilter includeFileFilter;
    @XStreamOmitField
    private transient WildcardFileFilter excludeFileFilter;

    public IncludeDir() {
    }

    public IncludeDir(IncludeDir orig) {
        this();
        if (orig != null) {
            this.dir = orig.dir;
            this.subdirs = orig.subdirs;
            if (orig.excludeDirs != null) {
                for (String path : orig.excludeDirs) {
                    this.excludeDirs.add(path);
                }
                if (orig.includeFiles != null) {
                    for (String path : orig.includeFiles) {
                        this.includeFiles.add(path);
                    }
                }
                if (orig.excludeFiles != null) {
                    for (String path : orig.excludeFiles) {
                        this.excludeFiles.add(path);
                    }
                }
            }
        }
    }

    public IncludeDir(IncludeDir orig, IncludeDir globals) {
        this();
        this.dir = orig.dir;
        if (this.dir == null) {
            this.dir = globals.dir;
        }
        this.subdirs = orig.subdirs;
        if (this.subdirs == null) {
            this.subdirs = globals.subdirs;
        }
        if (orig.excludeDirs != null) {
            for (String path : orig.excludeDirs) {
                this.excludeDirs.add(path);
            }
        }
        if (globals.excludeDirs != null) {
            for (String path : globals.excludeDirs) {
                this.excludeDirs.add(path);
            }
        }
        if (orig.includeFiles != null) {
            for (String path : orig.includeFiles) {
                this.includeFiles.add(path);
            }
        }
        if (globals.includeFiles != null) {
            for (String path : globals.includeFiles) {
                this.includeFiles.add(path);
            }
        }
        if (orig.excludeFiles != null) {
            for (String path : orig.excludeFiles) {
                this.excludeFiles.add(path);
            }
        }
        if (globals.excludeFiles != null) {
            for (String path : globals.excludeFiles) {
                this.excludeFiles.add(path);
            }
        }
    }

    private IncludeDir readResolve() {
        if (this.subdirs == null) {
            this.subdirs = true;
        }
        if (this.excludeDirs == null) {
            this.excludeDirs = new ArrayList<String>(0);
        }
        if (this.includeFiles == null) {
            this.includeFiles = new ArrayList<String>(0);
        }
        if (this.excludeFiles == null) {
            this.excludeFiles = new ArrayList<String>(0);
        }
        return this;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public Boolean getSubdirs() {
        return this.subdirs;
    }

    public void setSubdirs(Boolean subdirs) {
        this.subdirs = subdirs;
    }

    public List<String> getExcludeDirs() {
        return this.excludeDirs;
    }

    public void setExcludeDirs(List<String> excludeDirs) {
        this.excludeDirs = excludeDirs;
    }

    public List<String> getIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeFiles(List<String> includeFiles) {
        this.includeFiles = includeFiles;
    }

    public List<String> getExcludeFiles() {
        return this.excludeFiles;
    }

    public void setExcludeFiles(List<String> excludeFiles) {
        this.excludeFiles = excludeFiles;
    }

    public MyDirectoryWalker getDirectoryWalker() {
        if (this.directoryWalker == null) {
            this.initDirectoryWalker();
        }
        return this.directoryWalker;
    }

    private void initDirectoryWalker() {
        this.directoryWalker = new MyDirectoryWalker(this.dir){

            protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
                return IncludeDir.this.acceptDir(directory);
            }

            protected void handleFile(File file, int depth, Collection results) throws IOException {
                if (IncludeDir.this.acceptFile(file)) {
                    results.add(file);
                }
            }
        };
    }

    private boolean acceptDir(File pathToDir) {
        String absolute = RewriteUtils.makeUniform(pathToDir.getAbsolutePath());
        for (String exclude : this.excludeDirs) {
            if (!absolute.endsWith(exclude)) continue;
            return false;
        }
        if (this.subdirs.booleanValue()) {
            return true;
        }
        return pathToDir.equals(this.dir);
    }

    private boolean acceptFile(File pathToFile) {
        if (this.includeFileFilter.accept(pathToFile)) {
            return this.excludeFileFilter == null || !this.excludeFileFilter.accept(pathToFile);
        }
        return false;
    }

    public void initialize() {
        this.directoryWalker = null;
        if (this.subdirs == null) {
            this.subdirs = true;
        }
        if (this.includeFiles == null) {
            this.includeFiles = new ArrayList<String>(1);
        }
        if (this.excludeFiles == null) {
            this.excludeFiles = new ArrayList<String>(0);
        }
        if (this.excludeDirs == null) {
            this.excludeDirs = new ArrayList<String>(0);
        }
        int i = 0;
        while (i < this.includeFiles.size()) {
            if (this.includeFiles.get(i) == null) {
                this.includeFiles.remove(i);
                continue;
            }
            this.includeFiles.set(i, RewriteUtils.makeUniform(this.includeFiles.get(i)));
            if (this.includeFiles.get(i) == null) {
                this.includeFiles.remove(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < this.excludeFiles.size()) {
            if (this.excludeFiles.get(i) == null) {
                this.excludeFiles.remove(i);
                continue;
            }
            this.excludeFiles.set(i, RewriteUtils.makeUniform(this.excludeFiles.get(i)));
            if (this.excludeFiles.get(i) == null) {
                this.excludeFiles.remove(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < this.excludeDirs.size()) {
            if (this.excludeDirs.get(i) == null) {
                this.excludeDirs.remove(i);
                continue;
            }
            this.excludeDirs.set(i, RewriteUtils.makeUniform(this.excludeDirs.get(i)));
            if (this.excludeDirs.get(i) == null) {
                this.excludeDirs.remove(i);
                continue;
            }
            ++i;
        }
        if (this.includeFiles.size() == 0) {
            this.includeFiles.add("*.*");
        }
        this.includeFileFilter = new WildcardFileFilter(this.includeFiles);
        if (this.excludeFiles.size() > 0) {
            this.excludeFileFilter = new WildcardFileFilter(this.excludeFiles);
        }
    }

    public String toString() {
        return this.toString("IncludeDir", "");
    }

    public String toString(String name, String prefix) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        sb.append(String.valueOf(prefix) + name + "[");
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  dir           = " + this.dir + (this.dir != null ? " --> " + this.dir.getAbsolutePath() : ""));
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  subdirs       = " + this.subdirs);
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  includeFiles  = ");
        if (this.includeFiles == null) {
            sb.append("null");
        } else {
            for (String file : this.includeFiles) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(file);
            }
        }
        first = true;
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  excludeFiles  = ");
        if (this.excludeFiles == null) {
            sb.append("null");
        } else {
            for (String file : this.excludeFiles) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(file);
            }
        }
        first = true;
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  excludeDirs   = ");
        if (this.excludeDirs == null) {
            sb.append("null");
        } else {
            for (String file : this.excludeDirs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(file);
            }
        }
        first = true;
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "]");
        return sb.toString();
    }
}

