/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.cuni.amis.utils.rewrite.IncludeDir;
import cz.cuni.amis.utils.rewrite.rewriter.Const;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="RewriteFilesConfig")
public class RewriteFilesConfig {
    @XStreamAlias(value="globals")
    private IncludeDir globals = new IncludeDir();
    @XStreamImplicit(itemFieldName="include")
    private List<IncludeDir> dirs = new ArrayList<IncludeDir>();

    public static RewriteFilesConfig loadXML(File xmlFile) {
        FileReader reader;
        if (xmlFile == null) {
            throw new IllegalArgumentException("'xmlFile' can't be null!");
        }
        try {
            reader = new FileReader(xmlFile);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException("File " + xmlFile.getAbsolutePath() + " not found: " + e1.getMessage(), e1);
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.autodetectAnnotations(true);
        xstream.alias(RewriteFilesConfig.class.getAnnotation(XStreamAlias.class).value(), RewriteFilesConfig.class);
        Object obj = xstream.fromXML((Reader)reader);
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (obj == null || !(obj instanceof RewriteFilesConfig)) {
            throw new RuntimeException("file " + xmlFile.getAbsolutePath() + " doesn't contain a xml with RewriteFilesConfig");
        }
        return (RewriteFilesConfig)obj;
    }

    public RewriteFilesConfig readResolve() {
        if (this.globals == null) {
            this.globals = new IncludeDir();
        }
        if (this.dirs == null) {
            this.dirs = new ArrayList<IncludeDir>();
        }
        return this;
    }

    public void initialize() {
        this.globals.initialize();
    }

    public IncludeDir getGlobals() {
        return this.globals;
    }

    public void setGlobals(IncludeDir globals) {
        this.globals = globals;
    }

    public List<IncludeDir> getDirs() {
        return this.dirs;
    }

    public void setDirs(List<IncludeDir> dirs) {
        this.dirs = dirs;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(prefix) + "RewriteFilesConfig[");
        sb.append(String.valueOf(Const.NEW_LINE) + this.globals.toString("Globals", String.valueOf(prefix) + "  "));
        for (IncludeDir dir : this.dirs) {
            sb.append(String.valueOf(Const.NEW_LINE) + dir.toString("Dir", String.valueOf(prefix) + "  "));
        }
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "]");
        return sb.toString();
    }
}

