/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite;

import cz.cuni.amis.utils.rewrite.IncludeDir;
import cz.cuni.amis.utils.rewrite.MyDirectoryWalker;
import cz.cuni.amis.utils.rewrite.RewriteFilesConfig;
import cz.cuni.amis.utils.rewrite.rewriter.Const;
import cz.cuni.amis.utils.rewrite.rewriter.Rewriter;
import cz.cuni.amis.utils.simple_logging.SimpleLogging;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RewriteFiles {
    private RewriteFilesConfig config;
    private Logger log;
    private boolean failure = false;

    public RewriteFiles(RewriteFilesConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("'config' can't be null!");
        }
        this.config = config;
    }

    public RewriteFiles(File xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("'xmlFile' can't be null!");
        }
        this.config = RewriteFilesConfig.loadXML(xmlFile);
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public synchronized boolean isOk() {
        return !this.failure;
    }

    public synchronized boolean rewrite() {
        this.failure = false;
        this.logInfo("=================================================");
        this.logInfo("Configuration: " + Const.NEW_LINE + this.config.toString());
        this.logInfo("=================================================");
        this.logInfo("Initializing...");
        this.config.initialize();
        this.logInfo("Iterating directories...");
        if (this.config.getDirs() == null || this.config.getDirs().size() == 0) {
            this.logWarning("NO DIRECTORIES DEFINED VIA <include> TAGS! ARBOTING!");
            return false;
        }
        int i = 1;
        int ok = 0;
        int ko = 0;
        int totalFiles = 0;
        for (IncludeDir origDir : this.config.getDirs()) {
            i = 1;
            IncludeDir includeDir = new IncludeDir(origDir, this.config.getGlobals());
            this.logInfo("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
            if (includeDir.getDir() == null) {
                this.logWarning("CONFIGURATION CONTAINS <includeDir> TAG WITHOUT dir ATTRIBUTE! OMITTING!");
                this.logWarning("IncludeDir config: ");
                this.logWarning(includeDir.toString("IncludeDir", "  "));
                continue;
            }
            this.logInfo("Directory: " + includeDir.getDir().getAbsolutePath());
            this.logInfo("Config:" + Const.NEW_LINE + includeDir.toString("Dir+Globals", "  "));
            this.logInfo("Initializing...");
            includeDir.initialize();
            Rewriter rewriter = null;
            if (includeDir.getSubstitutions() != null && includeDir.getSubstitutions().size() > 0) {
                this.logInfo("Initializing substitutions...");
                rewriter = new Rewriter(includeDir.getSubstitutions());
                rewriter.setLog(this.log);
            } else {
                this.logInfo("No substitutions defined.");
            }
            if (includeDir.getLineEndings() != null) {
                this.logInfo("Using " + includeDir.getLineEndings() + ".");
            }
            this.logInfo("Initializing directory walker...");
            MyDirectoryWalker walker = includeDir.getDirectoryWalker();
            this.logInfo("Collecting files...");
            List<File> files = walker.walk(includeDir.getDir());
            if (files == null || files.size() == 0) {
                this.logWarning("NO FILES FOUND FOR THIS INCLUDE!");
            } else {
                this.logInfo("Matched " + files.size() + " files.");
                this.logInfo("Rewriting!");
                for (File file : files) {
                    this.logInfo("-------------------------------------------------");
                    this.logInfo("Rewriting (" + i + " / " + files.size() + "): " + file.getAbsolutePath());
                    boolean exception = false;
                    try {
                        boolean rewritten = false;
                        if (rewriter != null) {
                            if (rewriter.rewriteFile(file)) {
                                rewritten = true;
                                this.logInfo("Rewritten.");
                            } else {
                                this.logInfo("No changes.");
                            }
                        }
                        if (includeDir.getLineEndings() != null) {
                            if (!includeDir.getLineEndings().isFixOnlyIfRewritten() || rewritten) {
                                if (includeDir.getLineEndings().fix(file)) {
                                    rewritten = true;
                                    this.logInfo("Line endings fixed.");
                                } else {
                                    this.logInfo("Line endings are consistent.");
                                }
                            } else if (includeDir.getLineEndings().isFixOnlyIfRewritten()) {
                                this.logInfo("File was not modified, line endings are not checked.");
                            }
                        }
                        if (rewritten) {
                            ++ok;
                        }
                    }
                    catch (IOException e) {
                        ++ko;
                        this.logSevere("FAILED TO REWRITE: " + file.getAbsolutePath());
                        e.printStackTrace();
                        exception = true;
                    }
                    ++i;
                }
            }
            totalFiles += files.size();
        }
        this.logInfo("-------------------------------------------------");
        this.logInfo("STATISTICS:");
        this.log.info("Total files:  " + totalFiles);
        this.log.info("Rewritten:    " + ok);
        if (ko != 0) {
            this.log.info("Failed:       " + ko);
            this.failure = true;
        } else {
            if (ok == 0) {
                this.log.info("NO FILES WERE CHANGED, OK!");
            } else {
                this.log.info("FILES REWRITTEN, OK!");
            }
            this.failure = false;
        }
        this.logInfo("FINISHED!");
        return !this.failure;
    }

    protected void logInfo(String msg) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(msg);
        }
    }

    protected void logWarning(String msg) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(msg);
        }
    }

    protected void logSevere(String msg) {
        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.severe(msg);
        }
    }

    protected static void example(Logger log) {
        log.info("<RewriteFilesConfig>" + Const.NEW_LINE + "    <!-- GLOBAL DEFINITIONS THAT APPLIED TO ALL <include> TAGS -->" + Const.NEW_LINE + "    <globals>" + Const.NEW_LINE + "        <includeFile>pom.xml</includeFile> <!-- WILDCARDS ALLOWED! -->" + Const.NEW_LINE + Const.NEW_LINE + "        <!--" + Const.NEW_LINE + "    \t    <excludeFile>...</excludeFile>" + Const.NEW_LINE + "    \t    MAY BE USED TO GLOBALLY EXCLUDE SOME FILES" + Const.NEW_LINE + "         -->" + Const.NEW_LINE + "        <excludeDir>.svn</excludeDir>      <!-- WILDCARDS NOT ALLOWED, RELATIVE PATH THAT IS BLOCKED == **/path/defined/in/exclude/dir -->" + Const.NEW_LINE + "        <substitutions>" + Const.NEW_LINE + "    \t    <substitution>" + Const.NEW_LINE + "    \t\t    <match>3.2.0</match>" + Const.NEW_LINE + "    \t\t    <replace>3.2.0-SNAPSHOT</replace>" + Const.NEW_LINE + "    \t\t    <caseSensitive>false</caseSensitive> <!-- DEFAULT IS TRUE -->" + Const.NEW_LINE + "    \t\t    </substitution>" + Const.NEW_LINE + "        </substitutions>" + Const.NEW_LINE + "        <fixLineEndings windowsStyle=\"true\" />" + Const.NEW_LINE + "    </globals>" + Const.NEW_LINE + Const.NEW_LINE + "    <!-- DEFINES DIRESTORIES TO WALK THROUGH, MAY ADD ADDITIONAL INCLUDEs/EXCLUDEs/SUBSTITUTIONS -->" + Const.NEW_LINE + "    <include dir=\"./data1\" />" + Const.NEW_LINE + "        <!-- JUST INHERITS ALL FROM <globals> -->" + Const.NEW_LINE + Const.NEW_LINE + "    <include dir=\"./data2\">" + Const.NEW_LINE + "        <!-- INCLUDES ALL *.java BUT SomeFile.java FILES -->" + Const.NEW_LINE + "        <includeFile>*.java</includeFile>" + Const.NEW_LINE + "        <excludeFile>SomeFile.java</excludeFile>" + Const.NEW_LINE + "    </include>" + Const.NEW_LINE + Const.NEW_LINE + "</RewriteFilesConfig>");
    }

    public static void main(String[] args) {
        RewriteFiles rewrite;
        String definition = "RewriteFiles.xml";
        if (args.length > 0 && (definition = args[0]) == null) {
            definition = "RewriteFiles.xml";
        }
        SimpleLogging.initLogging();
        Logger log = Logger.getAnonymousLogger();
        log.info("---[[ REWRITE FILES ]]---");
        log.info("Loading definition from xml file: " + definition + " --> " + new File(definition).getAbsoluteFile());
        File file = new File(definition);
        if (!file.exists() || !file.isFile()) {
            log.severe("FAILED! Definition file not found at: " + file.getAbsolutePath());
            log.severe("Usage: java -jar RewriteFiles.jar [path-to-definition-xml-file]");
            RewriteFiles.example(log);
            log.info("---[[ END ]]---");
            System.exit(1);
            return;
        }
        try {
            rewrite = new RewriteFiles(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Usage: java -jar RewriteFiles.jar [path-to-definition-xml-file]");
            RewriteFiles.example(log);
            log.info("---[[ END ]]---");
            return;
        }
        rewrite.setLog(log);
        log.info("Definition file loaded.");
        boolean result = rewrite.rewrite();
        if (result) {
            log.info("System.exit(0)");
        } else {
            log.warning("Failure! System.exit(1)!");
            System.exit(1);
        }
        log.info("---[[ END ]]---");
        if (result) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

