/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.image.compare;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;

public class ImagePixelCompare {
    private File[] files = new File[2];
    private BufferedImage[] images = new BufferedImage[2];
    private Set<Integer>[] colors = new Set[]{new HashSet(), new HashSet()};

    public ImagePixelCompare(BufferedImage image1, BufferedImage image2) {
        this.images[0] = image1;
        this.images[1] = image2;
    }

    public ImagePixelCompare(File image1, File image2) {
        this.files[0] = image1;
        this.files[1] = image2;
        this.loadFiles();
    }

    private void loadFiles() {
        System.out.println("Loading images...");
        int i = 0;
        while (i < this.files.length) {
            if (this.files[i] != null) {
                if (!this.files[i].exists()) {
                    throw new RuntimeException("File of image " + (i + 1) + " (" + this.files[i].getAbsolutePath() + ") does not exist!");
                }
                try {
                    this.images[i] = ImageIO.read(this.files[i]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read image from: " + this.files[i]);
                }
            }
            ++i;
        }
    }

    public void compare() {
        System.out.println("ANALYZING!");
        if (this.files[0] != null) {
            System.out.println("Image 1:            " + this.files[0].getAbsolutePath());
            System.out.println("Image 2:            " + this.files[1].getAbsolutePath());
        }
        if (this.images[0] == null) {
            throw new RuntimeException("images[0] is null, initialization failed!");
        }
        if (this.images[1] == null) {
            throw new RuntimeException("images[1] is null, initialization failed!");
        }
        if (this.images[0].getWidth() != this.images[1].getWidth()) {
            throw new RuntimeException("images[0].getWidth() == " + this.images[0].getWidth() + " != " + this.images[1].getWidth() + " == images[1].getWidth(), images width mismatch!");
        }
        if (this.images[0].getHeight() != this.images[1].getHeight()) {
            throw new RuntimeException("images[0].getHeight() == " + this.images[0].getHeight() + " != " + this.images[1].getHeight() + " == images[1].getHeight(), images height mismatch!");
        }
        int pixels = this.images[0].getWidth() * this.images[1].getWidth();
        double deltaA = 0.0;
        double deltaR = 0.0;
        double deltaG = 0.0;
        double deltaB = 0.0;
        int x = 0;
        while (x < this.images[0].getWidth()) {
            int y = 0;
            while (y < this.images[0].getHeight()) {
                int pixel1 = this.images[0].getRGB(x, y);
                this.colors[0].add(pixel1);
                int alpha1 = pixel1 >> 24 & 0xFF;
                int red1 = pixel1 >> 16 & 0xFF;
                int green1 = pixel1 >> 8 & 0xFF;
                int blue1 = pixel1 & 0xFF;
                int pixel2 = this.images[1].getRGB(x, y);
                this.colors[1].add(pixel2);
                int alpha2 = pixel2 >> 24 & 0xFF;
                int red2 = pixel2 >> 16 & 0xFF;
                int green2 = pixel2 >> 8 & 0xFF;
                int blue2 = pixel2 & 0xFF;
                deltaA += (double)Math.abs(alpha1 - alpha2);
                deltaR += (double)Math.abs(red1 - red2);
                deltaG += (double)Math.abs(green1 - green2);
                deltaB += (double)Math.abs(blue1 - blue2);
                ++y;
            }
            ++x;
        }
        System.out.println("DONE!");
        System.out.println("Image:              " + this.images[0].getWidth() + "x" + this.images[0].getWidth() + " = " + pixels + " pixels");
        System.out.println("Image1 colors:      " + this.colors[0].size());
        System.out.println("Image2 colors:      " + this.colors[1].size());
        System.out.println("Total delta RED:    " + deltaR);
        System.out.println("Total delta GREEN:  " + deltaG);
        System.out.println("Total delta BLUE:   " + deltaB);
        System.out.println("Avg delta RED:      " + deltaR / (double)pixels);
        System.out.println("Avg delta GREEN:    " + deltaG / (double)pixels);
        System.out.println("Avg delta BLUE:     " + deltaB / (double)pixels);
        System.out.println("END!");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            ImagePixelCompare.printHelp();
            return;
        }
        File file1 = new File(args[0]);
        File file2 = new File(args[1]);
        ImagePixelCompare compare = new ImagePixelCompare(file1, file2);
        compare.compare();
    }

    private static void printHelp() {
        System.out.println("===================");
        System.out.println("IMAGE PIXEL COMPARE");
        System.out.println("===================");
        System.out.println("");
        System.out.println("This program computes color distances between two images (separately for every channel)");
        System.out.println("");
        System.out.println("Usage: java -jar image-pixel-compare.jar <path_to_image_1> <path_to_image_2>");
        System.out.println("");
        System.out.println("Example: java -jar image-pixel-compare.jar img1.png img2.jpg");
        System.out.println("");
    }
}

