package cz.cuni.amis.utils.eh4j.shortcut;

import java.util.Collection;

import cz.cuni.amis.utils.eh4j.EnumObject;
import cz.cuni.amis.utils.eh4j.EnumType;
import cz.cuni.amis.utils.eh4j.Enums;

/**
 * Shortcuts for quickly enumerating enums
 * @author Jimmy
 */
public class EH {

	/**
	 * Returns {@link EnumType} for given 'enumClass'.
	 * @param enumClass
	 * @return
	 */
	public static EnumType type(Class enumClass) {
		return Enums.getInstance().getEnumType(enumClass);
	}
	
	/**
	 * Returns {@link EnumType} for given user 'enumInstance'.
	 * @param enumInstance
	 * @return
	 */
	public static EnumType type(Object enumInstance) {
		return Enums.getInstance().getEnumType(enumInstance);
	}
	
	// ===========
	// TRANSLATION
	// ===========
	
	/**
	 * Returns {@link EnumObject} internally representing user 'enumInstance'.
	 * @param enumInstance
	 * @return
	 */
	public static EnumObject getEnumObject(Object enumInstance) {
		return Enums.getInstance().getEnumObject(enumInstance);
	}
	
	/**
	 * Returns {@link EnumObject} having name of 'enumName'.
	 * @param enumInstance
	 * @return
	 */
	public static EnumObject getEnumObjectForName(String enumName) {
		return Enums.getInstance().getEnumObject(enumName);
	}
	
	// ===================
	// USER ENUM INSTANCES
	// ===================
	
	/**
	 * Returns name of the enumInstance.
	 * @param enumInstance
	 * @return
	 */
	public static String name(Object enumInstance) {
		EnumObject eo = getEnumObject(enumInstance);
		if (eo == null) return "null";
		return eo.name;
	}
	
	/**
	 * Returns user enum instances defined for given 'enumClass'.
	 * @param enumClass
	 * @return
	 */
	public static <T> Collection<T> enums(Class<T> enumClass) {
		return type(enumClass).enums(enumClass);
	}
	
	/**
	 * Returns all (own+inherited) user enum instances defined for given 'enumClass'.
	 * @param enumClass
	 * @return
	 */
	public static <T> Collection<? extends T> enumsAll(Class<T> enumClass) {
		return type(enumClass).enumsAll(enumClass);
	}
	
	/**
	 * Returns user enum instances defined for given 'enumClass'.
	 * @param enumClass
	 * @param asEnums
	 * @return
	 */
	public static <T> Collection<T> enums(Class enumClass, Class<T> asEnums) {
		return type(enumClass).enums(asEnums);
	}
	
	/**
	 * Returns all (own+inherited) user enum instances defined for given 'enumClass'.
	 * @param enumClass
	 * @param asEnums
	 * @return
	 */
	public static <T> Collection<? extends T> enumsAll(Class enumClass, Class<T> asEnums) {
		return type(enumClass).enumsAll(asEnums);
	}
	
	// ============
	// ENUM OBJECTS
	// ============
	
	/**
	 * Returns internal {@link EnumObject} representation of user enum instances defined for given 'enumClass'.
	 * @param enumClass
	 * @return
	 */
	public static Collection<EnumObject> enumObjects(Class enumClass) {
		return type(enumClass).enumObjects();
	}
	
	/**
	 * Returns all (own+inherited) internal {@link EnumObject} representation of user enum instances defined for given 'enumClass'.
	 * @param enumClass
	 * @return
	 */
	public static Collection<EnumObject> enumObjectsAll(Class enumClass) {
		return type(enumClass).enumObjectsAll();
	}
	
	// ==============
	// ENUM HIERARCHY
	// ==============
	
	public static boolean isA(Object enumInstance, Object ofThisEnumInstance) {
		if (enumInstance == null) return false;
		if (enumInstance == ofThisEnumInstance) return true;
		EnumType type = type(enumInstance);
		if (type == null) return false;
		return type.isA(ofThisEnumInstance);
	}
	
	public static boolean isA(Object enumInstance, Class enumClass) {
		if (enumInstance == null) return false;
		EnumObject enumObject = getEnumObject(enumInstance);
		return enumObject.isA(enumClass);		
	}
	
	public static <T> T getAs(Object enumInstance, Class<T> enumClass) {
		if (enumInstance == null) return null;
		EnumObject enumObject = getEnumObject(enumInstance);
		return enumObject.getAs(enumClass);
	}
	
	public static <T> T getAsForName(String name, Class<T> enumClass) {
		if (name == null) return null;
		EnumObject enumObject = getEnumObjectForName(name);
		return enumObject.getAs(enumClass);
	}
	
}
