/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.elements.EnumValue;

public class ParamInfo
implements Comparable<ParamInfo> {
    public final String name;
    public final Type type;
    public final String clsName;

    public ParamInfo(String name, Type type, String clsName) {
        assert (name != null);
        this.name = name;
        this.type = type;
        this.clsName = clsName;
    }

    @Override
    public int compareTo(ParamInfo o) {
        return this.name.compareTo(o.name);
    }

    public boolean isValueAssignable(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)value;
            return this.clsName.equals(enumValue.getEnumFQN());
        }
        String javaClass = value.getClass().getName();
        return this.type.representsType(javaClass);
    }

    public static enum Type {
        BOOLEAN(true, Boolean.TYPE, Boolean.class),
        INT(true, Integer.TYPE, Integer.class),
        DOUBLE(true, Double.TYPE, Double.class),
        STRING(true, String.class),
        ENUM(false, Enum.class);

        private final boolean exactType;
        private final Class[] javaTypes;

        private Type(boolean exactType, Class ... javaTypes) {
            this.exactType = exactType;
            this.javaTypes = javaTypes;
        }

        public static Type findType(String javaType) {
            for (Type type : Type.values()) {
                if (!type.representsType(javaType)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unable to find " + Type.class.getSimpleName() + " for " + javaType);
        }

        boolean representsType(String testedJavaType) {
            if (this.exactType) {
                for (Class javaType : this.javaTypes) {
                    if (!javaType.getName().equals(testedJavaType)) continue;
                    return true;
                }
            } else {
                try {
                    Class<?> testedType = Class.forName(testedJavaType);
                    for (Class javaType : this.javaTypes) {
                        if (!javaType.isAssignableFrom(testedType)) continue;
                        return true;
                    }
                }
                catch (ClassNotFoundException ex) {
                    return false;
                }
            }
            return false;
        }
    }
}

