/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PoshDummyElementTest {
    private final String elementPrefix = "sense";
    int numTestElements = 10;
    int numTest = 100;
    List<Sense> elements;
    PoshDummyElementImpl<Sense> instance;

    @Before
    public void setUp() {
        this.elements = new LinkedList<Sense>();
        for (int i = 0; i < this.numTestElements; ++i) {
            this.elements.add(new Sense("sense" + i));
        }
        this.instance = new PoshDummyElementImpl<Sense>("test-posh-dummy-element", this.elements);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testPattern() {
        String pattern = "([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*";
        String[] ok = new String[]{"succeed", "cz.cuni.pogamut.Fail", "prime3", "A-B.Nya12", "www.kernel.com", "welcome-home.Kill_All_Humans.Was-there-2"};
        String[] crash = new String[]{" succeed", "succ eed", "123ahoj", "Nya.123.ahoj", "Baka(Evil)", "Hello*World", "Durable/Goods", "red@envelope", ".hu", "one..two"};
        for (String test : ok) {
            Assert.assertTrue((String)test, (boolean)test.matches(pattern));
        }
        for (String test : crash) {
            Assert.assertFalse((String)test, (boolean)test.matches(pattern));
        }
    }

    @Test
    public void testIsUsedName() {
        System.out.println("isUsedName");
        for (int i = 0; i < this.numTestElements; ++i) {
            Assert.assertTrue((boolean)PoshDummyElement.isUsedName((String)("sense" + i), this.elements));
            Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)("sense" + (i + this.numTestElements)), this.elements));
        }
        Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)"World-is-doomed", this.elements));
        Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)"walk-ahead", this.elements));
    }

    @Test
    public void testGetUnusedName() {
        System.out.println("getUnusedName");
        System.out.print("Unused names:");
        for (int i = 0; i < this.numTest; ++i) {
            String unusedName = PoshDummyElement.getUnusedName((String)"sense", this.elements);
            System.out.print(" " + unusedName);
            Assert.assertFalse((boolean)PoshDummyElement.isUsedName((String)unusedName, this.elements));
            this.elements.add(new Sense(unusedName));
        }
        System.out.println();
    }

    public static class PoshDummyElementImpl<T extends PoshElement>
    extends PoshDummyElement {
        private final String name;
        private final List<T> elements;

        PoshDummyElementImpl(String name, List<T> elements) {
            this.name = name;
            this.elements = Collections.unmodifiableList(elements);
        }

        public DataFlavor getDataFlavor() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<T> getChildDataNodes() {
            return this.elements;
        }

        public String getName() {
            return this.name;
        }

        public boolean moveChild(int newIndex, PoshElement child) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LapType getType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

