/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.SenseExecutor;
import cz.cuni.amis.pogamut.sposh.engine.SenseResult;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class SenseListExecutor<T extends PoshElement>
extends AbstractExecutor {
    private List<SenseExecutor> sensesExecutors = new ArrayList<SenseExecutor>();

    SenseListExecutor(Trigger<T> trigger, LapPath senseListPath, VariableContext ctx, EngineLog engineLog) {
        super(senseListPath, ctx, engineLog);
        int triggerSenseId = 0;
        for (Sense sense : trigger) {
            LapPath triggerSensePath = senseListPath.concat(LapType.SENSE, triggerSenseId++);
            SenseExecutor senseExecutor = new SenseExecutor(sense, triggerSensePath, ctx, engineLog);
            this.sensesExecutors.add(senseExecutor);
        }
    }

    SenseListExecutor(LapPath senseListPath, VariableContext ctx, EngineLog log) {
        super(senseListPath, ctx, log);
    }

    public TriggerResult fire(IWorkExecutor workExecuter, boolean defaultReturn) {
        LinkedList<SenseResult> senses = new LinkedList<SenseResult>();
        for (SenseExecutor senseExecutor : this.sensesExecutors) {
            defaultReturn = true;
            SenseResult res = senseExecutor.fire(workExecuter);
            senses.add(res);
            if (res.wasSuccessful()) continue;
            return new TriggerResult(senses, false);
        }
        return new TriggerResult(senses, defaultReturn);
    }
}

