/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.INodeExecutor;
import cz.cuni.amis.pogamut.sposh.engine.NodeExecutor;
import cz.cuni.amis.pogamut.sposh.engine.NodeResult;
import cz.cuni.amis.pogamut.sposh.engine.NodeState;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.Deque;
import java.util.LinkedList;

class DriveNodeExecutor
extends NodeExecutor<DriveElement>
implements INodeExecutor {
    final Deque<INodeExecutor> stack = new LinkedList<INodeExecutor>();
    private final ITimer timer;
    private final SenseListExecutor<DriveElement> triggerExecutor;
    private long lastFired = Integer.MAX_VALUE;

    public DriveNodeExecutor(PoshPlan plan, LapPath path, VariableContext ctx, EngineLog engineLog, ITimer timer) {
        super(plan, path, ctx, engineLog);
        this.timer = timer;
        this.triggerExecutor = new SenseListExecutor(path, ctx, engineLog);
    }

    INodeExecutor createExecutor(PrimitiveCall actionCall) {
        throw new UnsupportedOperationException("TODO: Implement");
    }

    boolean isElegible(IWorkExecutor workExecutor, long timestamp) {
        long passed = timestamp - this.lastFired;
        Freq freq = ((DriveElement)this.node).getFreq();
        if (Freq.compare(freq.tick(), passed) > 0) {
            this.engineLog.fine("Max.firing frequency for drive " + ((DriveElement)this.node).getName() + " exceeded, has to be at least " + freq.tick() + "ms, but was only " + passed);
            return false;
        }
        TriggerResult result = this.triggerExecutor.fire(workExecutor, true);
        return result.wasSuccess();
    }

    private PrimitiveCall getActionCall() {
        return ((DriveElement)this.node).getAction().getActionCall();
    }

    @Override
    public NodeResult evaluate(IWorkExecutor workExecutor) {
        this.engineLog.pathReached(this.path);
        this.engineLog.finest("Stack of drive " + ((DriveElement)this.node).getName() + " is empty, adding initial element: " + this.getActionCall().toString());
        this.lastFired = this.timer.getTime();
        return new NodeResult(NodeState.FOLLOW, this.createExecutor(this.getActionCall()));
    }

    @Override
    public NodeResult childEvaluated(NodeState result) {
        this.engineLog.pathReached(this.path);
        this.lastFired = this.timer.getTime();
        switch (result) {
            case CONTINUE: {
                return new NodeResult(NodeState.FOLLOW, this.createExecutor(this.getActionCall()));
            }
            case DONE: {
                return new NodeResult(NodeState.DONE, this);
            }
            case FAILED: {
                return new NodeResult(NodeState.FAILED, this);
            }
        }
        throw new IllegalArgumentException("Unsupported result: " + (Object)((Object)result));
    }

    @Override
    public LapType getType() {
        return LapType.DRIVE_ELEMENT;
    }

    void interrupt() {
        this.stack.clear();
    }
}

