/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.elements.EnumValue;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.exceptions.MethodException;
import cz.cuni.amis.pogamut.sposh.executor.EnumAction;
import cz.cuni.amis.pogamut.sposh.executor.EnumSense;
import cz.cuni.amis.pogamut.sposh.executor.IAction;
import cz.cuni.amis.pogamut.sposh.executor.ISense;
import cz.cuni.amis.pogamut.sposh.executor.NonPublicEnumSense;
import cz.cuni.amis.pogamut.sposh.executor.StateWorkExecutor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnumParam
extends Assert {
    private StateWorkExecutor executor;

    @Before
    public void setUp() {
        this.executor = new StateWorkExecutor();
    }

    @Test
    public void enumInAction() {
        VariableContext ctx = new VariableContext();
        ctx.put("$enumVar", (Object)new EnumValue("java.lang.annotation.RetentionPolicy.SOURCE"));
        EnumAction action = new EnumAction();
        this.executor.addAction("action", (IAction)action);
        this.executor.executeAction("action", ctx);
    }

    @Test
    public void enumInSense() {
        VariableContext ctx = new VariableContext();
        ctx.put("$enumVar", (Object)new EnumValue("java.lang.annotation.RetentionPolicy.RUNTIME"));
        EnumSense sense = new EnumSense();
        this.executor.addSense("sense", (ISense)sense);
        this.executor.executeSense("sense", ctx);
    }

    @Test(expected=MethodException.class)
    public void wrongEnumConstantName() {
        VariableContext ctx = new VariableContext();
        ctx.put("$enumVar", (Object)new EnumValue("java.lang.annotation.RetentionPolicy.DUMMY"));
        EnumSense sense = new EnumSense();
        this.executor.addSense("sense", (ISense)sense);
        this.executor.executeSense("sense", ctx);
    }

    @Test(expected=MethodException.class)
    public void wrongEnumClassName() {
        VariableContext ctx = new VariableContext();
        ctx.put("$enumVar", (Object)new EnumValue("dummy.lang.annotation.RetentionPolicy.SOURCE"));
        EnumSense sense = new EnumSense();
        this.executor.addSense("sense", (ISense)sense);
        this.executor.executeSense("sense", ctx);
    }

    @Test(expected=MethodException.class)
    public void nonStringToEnum() {
        VariableContext ctx = new VariableContext();
        ctx.put("$enumVar", (Object)new Integer(15));
        EnumAction action = new EnumAction();
        this.executor.addAction("action", (IAction)action);
        this.executor.executeAction("action", ctx);
    }

    @Test(expected=NoSuchMethodError.class)
    public void testNonPublicEnum() {
        this.executor.addSense(NonPublicEnumSense.class.getSimpleName(), (ISense)new NonPublicEnumSense());
    }
}

