/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

class APExecutor
extends AbstractExecutor
implements ElementExecutor {
    private final PoshPlan plan;
    private final ActionPattern actionPattern;
    private int index = 0;
    private FireResult.Type result;

    APExecutor(PoshPlan plan, ActionPattern ap, FireResult.Type result, LapPath apPath, VariableContext ctx, EngineLog log) {
        super(apPath, ctx, log);
        assert (apPath.traversePath(plan) == ap);
        this.plan = plan;
        this.actionPattern = ap;
        this.index = 0;
        this.result = result;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        this.engineLog.pathReached(this.path);
        if (this.index == this.actionPattern.getActions().size()) {
            return new FireResult(this.result);
        }
        TriggeredAction action = this.actionPattern.getActions().get(this.index);
        StackElement stackElement = this.createActionExecutor(action.getActionCall());
        return new FireResult(FireResult.Type.FOLLOW, stackElement);
    }

    private StackElement createActionExecutor(PrimitiveCall actionCall) {
        LapPath actionPath = this.path.concat(LapType.ACTION, this.index);
        StackElement element = this.getElement(this.plan, actionCall, actionPath, new Runnable(){

            @Override
            public void run() {
                ++APExecutor.this.index;
            }
        }, null, new Runnable(){

            @Override
            public void run() {
                ++APExecutor.this.index;
            }
        }, null);
        if (element.getExecutor() instanceof APExecutor) {
            ++this.index;
        }
        return element;
    }
}

