/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.INodeExecutor;
import cz.cuni.amis.pogamut.sposh.engine.NodeExecutor;
import cz.cuni.amis.pogamut.sposh.engine.NodeResult;
import cz.cuni.amis.pogamut.sposh.engine.NodeState;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

class ActionNodeExecutor
extends NodeExecutor<TriggeredAction>
implements INodeExecutor {
    public ActionNodeExecutor(PoshPlan plan, LapPath actionPath, VariableContext ctx, EngineLog engineLog) {
        super(plan, actionPath, ctx, engineLog);
    }

    @Override
    public NodeResult evaluate(IWorkExecutor workExecutor) {
        this.engineLog.pathReached(this.path);
        ActionResult result = workExecutor.executeAction(((TriggeredAction)this.node).getActionCall().getName(), this.ctx);
        switch (result) {
            case FAILED: {
                return new NodeResult(NodeState.FAILED, this);
            }
            case FINISHED: {
                return new NodeResult(NodeState.DONE, this);
            }
            case RUNNING: {
                return new NodeResult(NodeState.CONTINUE, this);
            }
            case RUNNING_ONCE: {
                return new NodeResult(NodeState.DONE, this);
            }
        }
        throw new IllegalStateException("Unexpected ActionResult: " + (Object)((Object)result));
    }

    @Override
    public NodeResult childEvaluated(NodeState result) {
        throw new FubarException("Action doesn't have children.");
    }

    @Override
    public final LapType getType() {
        return LapType.ACTION;
    }
}

