/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.elements.EnumValue;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.amis.pogamut.sposh.executor.TestEnum;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;

public class ParamInfoTest
extends Assert {
    @Test(expected=IllegalArgumentException.class)
    public void representsExact() {
        ParamInfo.Type.findType((String)"non.existent");
    }

    @Test(expected=IllegalArgumentException.class)
    public void existingNonrepresentingClass() {
        ParamInfo.Type.findType((String)BigInteger.class.getName());
    }

    @Test
    public void representsInt() {
        ParamInfoTest.assertEquals((Object)ParamInfo.Type.INT, (Object)ParamInfo.Type.findType((String)"int"));
    }

    @Test
    public void representsInteger() {
        ParamInfoTest.assertEquals((Object)ParamInfo.Type.INT, (Object)ParamInfo.Type.findType((String)"java.lang.Integer"));
    }

    @Test
    public void representsdouble() {
        ParamInfoTest.assertEquals((Object)ParamInfo.Type.DOUBLE, (Object)ParamInfo.Type.findType((String)"double"));
    }

    @Test
    public void representsDouble() {
        ParamInfoTest.assertEquals((Object)ParamInfo.Type.DOUBLE, (Object)ParamInfo.Type.findType((String)"java.lang.Double"));
    }

    @Test
    public void representsString() {
        ParamInfoTest.assertEquals((Object)ParamInfo.Type.STRING, (Object)ParamInfo.Type.findType((String)"java.lang.String"));
    }

    @Test
    public void representsSomeEnum() {
        ParamInfoTest.assertEquals((Object)ParamInfo.Type.ENUM, (Object)ParamInfo.Type.findType((String)TestEnum.class.getName()));
    }

    @Test
    public void stringIsAssignableToSTRING() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.STRING, String.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable((Object)"Hello"));
    }

    @Test
    public void incompatibleAssignemntToSTRING() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.STRING, String.class.getName());
        ParamInfoTest.assertFalse((boolean)paramInfo.isValueAssignable((Object)15));
    }

    @Test
    public void intAssignableToINT() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.INT, Integer.TYPE.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable((Object)15));
    }

    @Test
    public void intAssignableToINTeger() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.INT, Integer.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable((Object)15));
    }

    @Test
    public void integerAssignableToINT() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.INT, Integer.TYPE.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable((Object)new Integer(99)));
    }

    @Test
    public void integerAssignableToINTeger() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.INT, Integer.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable((Object)new Integer(99)));
    }

    @Test
    public void enumAssignableToEnum() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.ENUM, TestEnum.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable((Object)new EnumValue(TestEnum.class.getName() + '.' + TestEnum.A.name())));
    }

    @Test
    public void stringNotAssignableToEnum() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.ENUM, TestEnum.class.getName());
        ParamInfoTest.assertFalse((boolean)paramInfo.isValueAssignable((Object)"Hello"));
    }

    @Test
    public void wrongEnumNotAssignableToEnum() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.ENUM, TestEnum.class.getName());
        ParamInfoTest.assertFalse((boolean)paramInfo.isValueAssignable((Object)new EnumValue("cz.team.OUR")));
    }

    @Test
    public void nilAssignableToEverything() {
        ParamInfo paramInfo = new ParamInfo("$name", ParamInfo.Type.INT, Integer.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable(null));
        paramInfo = new ParamInfo("$name", ParamInfo.Type.DOUBLE, Double.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable(null));
        paramInfo = new ParamInfo("$name", ParamInfo.Type.STRING, String.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable(null));
        paramInfo = new ParamInfo("$name", ParamInfo.Type.ENUM, TestEnum.class.getName());
        ParamInfoTest.assertTrue((boolean)paramInfo.isValueAssignable(null));
    }
}

