/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.AddTest;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IElementMethod;
import cz.cuni.amis.pogamut.sposh.elements.IPropertyMethod;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PropertyTest;
import cz.cuni.amis.pogamut.sposh.elements.RemoveTest;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class PoshPlanTest {
    private String name = "life";
    private PoshPlan instance;
    private int numAPs = 10;
    private String apPrefix = "ap-";
    private List<ActionPattern> aps;
    private int numCs = 12;
    private String cPrefix = "c-";
    private List<Competence> cs;

    @Before
    public void setUp() {
        this.instance = LapElementsFactory.createPlan((String)this.name);
    }

    @After
    public void tearDown() {
        this.aps = null;
        this.cs = null;
        this.instance = null;
    }

    private void createAPs() {
        this.aps = new ArrayList<ActionPattern>(this.numAPs);
        for (int i = 0; i < this.numAPs; ++i) {
            List<TriggeredAction> actions = Arrays.asList(LapElementsFactory.createAction((String)(this.apPrefix + i + "action")));
            ActionPattern ap = new ActionPattern(this.apPrefix + i, new FormalParameters(), actions, "");
            this.aps.add(ap);
        }
    }

    private void fillAPs() throws DuplicateNameException, CycleException {
        if (this.aps == null) {
            this.createAPs();
        }
        for (ActionPattern ap : this.aps) {
            this.instance.addActionPattern(ap);
        }
    }

    private void createCs() throws DuplicateNameException {
        this.cs = new ArrayList<Competence>(this.numCs);
        for (int i = 0; i < this.numCs; ++i) {
            Competence c = LapElementsFactory.createCompetence((String)(this.cPrefix + i), (String[])new String[]{this.cPrefix + i + "action"});
            this.cs.add(c);
        }
    }

    private void fillCs() throws DuplicateNameException, CycleException {
        if (this.cs == null) {
            this.createCs();
        }
        for (Competence c : this.cs) {
            this.instance.addCompetence(c);
        }
    }

    @Test
    @Ignore
    public void testIsC() {
        System.out.println("isC");
        String name = "";
        Object instance = null;
        boolean expResult = false;
        boolean result = instance.isC(name);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    @Ignore
    public void testGetC() {
        System.out.println("getC");
        String name = "";
        Object instance = null;
        Object expResult = null;
        Competence result = instance.getC(name);
        Assert.assertEquals(expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    @Ignore
    public void testIsAP() {
        System.out.println("isAP");
        String name = "";
        Object instance = null;
        boolean expResult = false;
        boolean result = instance.isAP(name);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    @Ignore
    public void testGetAP() {
        System.out.println("getAP");
        String name = "";
        Object instance = null;
        Object expResult = null;
        ActionPattern result = instance.getAP(name);
        Assert.assertEquals(expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    @Ignore
    public void testIsUniqueAPorComp() {
        System.out.println("isUniqueAPorComp");
        String testedName = "";
        Object instance = null;
        boolean expResult = false;
        boolean result = instance.isUniqueNodeName(testedName);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    public void testAddCompetence() throws Exception {
        System.out.println("addCompetence");
        this.fillAPs();
        this.createCs();
        IElementMethod<PoshPlan, Competence> method = new IElementMethod<PoshPlan, Competence>(){

            @Override
            public void method(PoshPlan element, Competence child) throws DuplicateNameException, CycleException {
                element.addCompetence(child);
            }
        };
        AddTest<PoshPlan, Competence> test = new AddTest<PoshPlan, Competence>(this.instance, this.cs, method, this.numAPs + 1, this.numAPs + this.numCs + 1);
        test.runTest();
    }

    @Test
    public void testSetName() throws Exception {
        System.out.println("setName");
        IPropertyMethod<PoshPlan, String> propertyMethod = new IPropertyMethod<PoshPlan, String>(){

            @Override
            public String get(PoshPlan element) throws Exception {
                return element.getName();
            }

            @Override
            public void set(PoshPlan element, String value) throws Exception {
                element.setName(value);
            }
        };
        String[] testValues = new String[]{"Hello", "World"};
        new PropertyTest<PoshPlan, String>("posh-plan-name", this.instance, propertyMethod, testValues).runTest();
    }

    @Test
    public void testSetAuthor() throws Exception {
        System.out.println("setAuthor");
        IPropertyMethod<PoshPlan, String> propertyMethod = new IPropertyMethod<PoshPlan, String>(){

            @Override
            public String get(PoshPlan element) throws Exception {
                return element.getAuthor();
            }

            @Override
            public void set(PoshPlan element, String value) throws Exception {
                element.setAuthor(value);
            }
        };
        String[] testValues = new String[]{"Joseph Heller", "Charler Babbage", "Ada Lovelace"};
        new PropertyTest<PoshPlan, String>("posh-plan-author", this.instance, propertyMethod, testValues).runTest();
    }

    @Test
    public void testSetInfo() throws Exception {
        System.out.println("setInfo");
        IPropertyMethod<PoshPlan, String> propertyMethod = new IPropertyMethod<PoshPlan, String>(){

            @Override
            public String get(PoshPlan element) throws Exception {
                return element.getInfo();
            }

            @Override
            public void set(PoshPlan element, String value) throws Exception {
                element.setInfo(value);
            }
        };
        String[] testValues = new String[]{"Overall failure", "The weak will perish"};
        new PropertyTest<PoshPlan, String>("posh-plan-info", this.instance, propertyMethod, testValues).runTest();
    }

    @Test
    public void testAddActionPattern() throws Exception {
        System.out.println("addActionPattern");
        this.fillCs();
        this.createAPs();
        IElementMethod<PoshPlan, ActionPattern> addMethod = new IElementMethod<PoshPlan, ActionPattern>(){

            @Override
            public void method(PoshPlan plan, ActionPattern ap) throws Exception {
                plan.addActionPattern(ap);
            }
        };
        AddTest<PoshPlan, ActionPattern> test = new AddTest<PoshPlan, ActionPattern>(this.instance, this.aps, addMethod, this.numCs + 1, this.numCs + this.numAPs + 1);
        test.runTest();
    }

    @Test
    @Ignore
    public void testIsCycled() {
        System.out.println("isCycled");
        boolean expResult = false;
        boolean result = this.instance.isCycled();
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    @Ignore
    public void testToString() {
        System.out.println("toString");
        String expResult = "";
        String result = this.instance.toString();
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    public void testGetChildDataNodes() throws DuplicateNameException, CycleException {
        System.out.println("getChildDataNodes");
        this.fillAPs();
        this.fillCs();
        List result = this.instance.getChildDataNodes();
        Assert.assertEquals((long)(this.aps.size() + this.cs.size() + 1), (long)result.size());
        for (ActionPattern ap : this.aps) {
            Assert.assertTrue((boolean)result.contains(ap));
        }
        for (Competence c : this.cs) {
            Assert.assertTrue((boolean)result.contains(c));
        }
        Assert.assertTrue((boolean)result.contains(this.instance.getDriveCollection()));
    }

    @Test
    @Ignore
    public void testMoveChild() {
        System.out.println("moveChild");
        PoshElement child = null;
        int newIndex = 0;
        boolean expResult = false;
        boolean result = this.instance.moveChild(newIndex, child);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    public void testRemoveCompetence() throws Exception {
        System.out.println("removeCompetence");
        this.fillCs();
        IElementMethod<PoshPlan, Competence> removeMethod = new IElementMethod<PoshPlan, Competence>(){

            @Override
            public void method(PoshPlan element, Competence child) {
                element.removeCompetence(child);
            }
        };
        RemoveTest<PoshPlan, Competence> test = new RemoveTest<PoshPlan, Competence>(this.instance, this.cs, removeMethod, 1, 1);
        test.runTest();
    }

    @Test
    public void testRemoveActionPattern() throws Exception {
        System.out.println("removeActionPattern");
        this.fillAPs();
        IElementMethod<PoshPlan, ActionPattern> removeMethod = new IElementMethod<PoshPlan, ActionPattern>(){

            @Override
            public void method(PoshPlan element, ActionPattern child) {
                element.removeActionPattern(child);
            }
        };
        RemoveTest<PoshPlan, ActionPattern> test = new RemoveTest<PoshPlan, ActionPattern>(this.instance, this.aps, removeMethod, 1, 1);
        test.runTest();
    }

    @Test
    @Ignore
    public void testSynchronize() throws Exception {
        System.out.println("synchronize");
        PoshPlan other = null;
        this.instance.synchronize(other);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    @Ignore
    public void testGetActionsNames() throws Exception {
        System.out.println("getActionsNames");
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    @Ignore
    public void testGetSensesNames() throws Exception {
        System.out.println("getSensesNames");
        Assert.fail((String)"The test case is a prototype.");
    }
}

