/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ArgumentsTest
extends Assert {
    private Arguments args;
    private FormalParameters formal;

    @Before
    public void setUp() {
        this.args = new Arguments();
        this.formal = new FormalParameters();
        this.formal.add((Object)new FormalParameters.Parameter("$intParam", (Object)12));
        this.formal.add((Object)new FormalParameters.Parameter("$doubleParam", (Object)Math.PI));
        this.formal.add((Object)new FormalParameters.Parameter("$boolParam", (Object)Boolean.FALSE));
        this.formal.add((Object)new FormalParameters.Parameter("$stringParam", (Object)"Hello World!"));
        this.args.addFormal((Arguments.Argument)new Arguments.ValueArgument("$valInt", (Object)Integer.MIN_VALUE), this.formal);
        this.args.addFormal((Arguments.Argument)new Arguments.ValueArgument("$valDouble", (Object)Math.E), this.formal);
        this.args.addFormal((Arguments.Argument)new Arguments.ValueArgument("$valBool", (Object)Boolean.TRUE), this.formal);
        this.args.addFormal((Arguments.Argument)new Arguments.ValueArgument("$valString", (Object)"Joe"), this.formal);
        this.args.addFormal((Arguments.Argument)new Arguments.VariableArgument("$varDoubleMax", "$doubleParam"), this.formal);
        this.args.addFormal((Arguments.Argument)new Arguments.VariableArgument("$varIntMin", "$intParam"), this.formal);
        this.args.addFormal((Arguments.Argument)new Arguments.VariableArgument("$varBool", "$boolParam"), this.formal);
        this.args.addFormal((Arguments.Argument)new Arguments.VariableArgument("$varString", "$stringParam"), this.formal);
    }

    @Test
    public void t() {
        Object[] expectedNames = new String[]{"$alpha", "$beta", "$gamma"};
        Arguments arguments = new Arguments();
        arguments.add((Object)new Arguments.ValueArgument("$beta", null));
        arguments.add((Object)new Arguments.ValueArgument("$gamma", null));
        arguments.add((Object)new Arguments.ValueArgument("$alpha", null));
        Object[] names = arguments.getAllNames();
        ArgumentsTest.assertArrayEquals((Object[])expectedNames, (Object[])names);
    }

    @Test
    public void size() {
        ArgumentsTest.assertEquals((long)8L, (long)this.args.size());
    }

    @Test
    public void intValue() {
        Arguments.Argument get = this.args.get(0);
        ArgumentsTest.assertEquals((Object)Integer.MIN_VALUE, (Object)get.getValue());
    }

    @Test
    public void doubleValue() {
        Arguments.Argument get = this.args.get(1);
        ArgumentsTest.assertEquals((Object)Math.E, (Object)get.getValue());
    }

    @Test
    public void boolValue() {
        Arguments.Argument get = this.args.get(2);
        ArgumentsTest.assertEquals((Object)Boolean.TRUE, (Object)get.getValue());
    }

    @Test
    public void stringValue() {
        Arguments.Argument get = this.args.get(3);
        ArgumentsTest.assertEquals((Object)"Joe", (Object)get.getValue());
    }

    @Test
    @Ignore
    public void intVariable() {
        Arguments.Argument get = this.args.get(4);
        ArgumentsTest.assertEquals((Object)Math.PI, (Object)get.getValue());
    }

    @Test
    @Ignore
    public void doubleVariable() {
        Arguments.Argument get = this.args.get(5);
        ArgumentsTest.assertEquals((Object)Math.E, (Object)get.getValue());
    }

    @Test
    @Ignore
    public void boolVariable() {
        Arguments.Argument get = this.args.get(6);
        ArgumentsTest.assertEquals((Object)Boolean.FALSE, (Object)get.getValue());
    }

    @Test
    @Ignore
    public void stringVariable() {
        Arguments.Argument get = this.args.get(7);
        ArgumentsTest.assertEquals((Object)"Hello World!", (Object)get.getValue());
    }
}

