/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PlanTest;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ITestPrimitive;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.PrintPrimitive;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TestWorkExecutor;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.DebugTimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.IAction;
import cz.cuni.amis.pogamut.sposh.executor.ISense;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.StateWorkExecutor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PoshEngineTest
extends PlanTest {
    private IWorkExecutor createWorkExecutor() {
        return new IWorkExecutor(){

            public ActionResult executeAction(String actionName, VariableContext ctx) {
                return null;
            }

            public Object executeSense(String senseName, VariableContext ctx) {
                return null;
            }
        };
    }

    @Test
    public void testGoalFulfilled() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestGoalFulfilled.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false)});
        PoshEngine.EvaluationResult result = poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result;
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.GOAL_SATISFIED, (Object)result);
    }

    @Test
    public void testParameterlessPrimitiveEvaluation() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestPrimitiveEvaluation.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive dummyPrimitive = new PrintPrimitive("dummyPrimitive", ActionResult.FAILED){

            @Override
            public Object work(VariableContext ctx) {
                Assert.assertEquals((long)ctx.size(), (long)0L);
                return super.work(ctx);
            }
        };
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), dummyPrimitive});
        PoshEngineTest.assertEquals((Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result, (Object)PoshEngine.EvaluationResult.ELEMENT_FIRED);
        if (dummyPrimitive.triggered() != 0) {
            PoshEngineTest.fail((String)"Primitive was triggered, shouldn't be, expected only to add primitive to stack.");
        }
        PoshEngineTest.assertEquals((Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result, (Object)PoshEngine.EvaluationResult.ELEMENT_FIRED);
        if (dummyPrimitive.triggered() != 1) {
            PoshEngineTest.fail((String)"Primitive wasn't triggered.");
        }
    }

    @Test
    public void testDEFrequencyFail() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        DebugTimer timer = new DebugTimer();
        PoshEngine poshEngine = new PoshEngine(this.parsePlan("testplans/TestDEFrequencyFail.lap"), (ITimer)timer);
        PrintPrimitive doNothingPrimitive = new PrintPrimitive("doNothing", ActionResult.FAILED);
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("fail", false), doNothingPrimitive});
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        for (int i = 0; i < 3; ++i) {
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.NO_ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.NO_ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            timer.addTime(250L);
            if (doNothingPrimitive.triggered() == 1) continue;
            PoshEngineTest.fail((String)"DE wasn't triggered just once");
        }
        System.out.println("Adding 300 so it is over 1000ms");
        timer.addTime(300L);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        if (doNothingPrimitive.triggered() != 2) {
            PoshEngineTest.fail((String)"DE wasn't triggered after freq limiter timeout");
        }
    }

    @Test
    public void testNoGoal() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestNoGoal.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive dummyPrimitive = new PrintPrimitive("dummyPrimitive", ActionResult.FAILED);
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{dummyPrimitive});
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        if (dummyPrimitive.triggered() != 0) {
            PoshEngineTest.fail((String)"Primitive was triggered, should only be added to stack.");
        }
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        if (dummyPrimitive.triggered() != 1) {
            PoshEngineTest.fail((String)"Primitive wasn't triggered.");
        }
    }

    @Test
    public void testAPExecutor() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestAPExecutor.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ITestPrimitive[] actions = new ITestPrimitive[3];
        int[] res = new int[]{0, 0, 0};
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = new PrintPrimitive("action" + i);
        }
        TestWorkExecutor workExecuter = new TestWorkExecutor(actions);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        this.checkPrimitives(actions, res);
        for (int i = 0; i < actions.length; ++i) {
            System.out.println(" * Firing action " + actions[i].getName());
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            this.checkPrimitives(actions, res);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            res[i] = 1;
            this.checkPrimitives(actions, res);
        }
    }

    private void checkPrimitives(ITestPrimitive[] primitives, int[] results) {
        for (int i = 0; i < primitives.length; ++i) {
            if (primitives[i].triggered() == results[i]) continue;
            throw new IllegalStateException("Primitive " + primitives[i].getName() + " wasn't triggered " + results[i] + " times, but " + primitives[i].triggered());
        }
    }

    @Test
    public void testPassedConstantsInPrimitive() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestPrimitiveVariables.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ITestPrimitive testVariable = new ITestPrimitive(){

            @Override
            public String getName() {
                return "testVariable";
            }

            @Override
            public Object work(VariableContext ctx) {
                if (!"Snowhite".equals(ctx.getValue("$name"))) {
                    throw new IllegalStateException("Variable $name is not snowhite, but " + ctx.getValue("$name"));
                }
                Assert.assertEquals((Object)ctx.getValue("0"), (Object)12.4);
                if (ctx.size() != 2) {
                    throw new IllegalStateException("More than two variables passed (\"" + ctx.size() + "\").");
                }
                return null;
            }

            @Override
            public int triggered() {
                return 0;
            }
        };
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{testVariable});
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
    }

    @Test
    public void testNestedAP() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestNestedAP.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        int[] res = new int[]{0, 0, 0, 0};
        ITestPrimitive[] actions = new ITestPrimitive[4];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = new PrintPrimitive("action" + i, ActionResult.FINISHED);
        }
        TestWorkExecutor workExecuter = new TestWorkExecutor(actions);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        res[0] = res[0] + 1;
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        res[1] = res[1] + 1;
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        res[2] = res[2] + 1;
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        this.checkPrimitives(actions, res);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        res[3] = res[3] + 1;
        this.checkPrimitives(actions, res);
    }

    @Test
    public void testNestedAPFailure() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestNestedAPFailure.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        int[] res = new int[]{0, 0, 0, 0};
        ITestPrimitive[] actions = new ITestPrimitive[4];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = i == 2 ? new PrintPrimitive("action" + i, ActionResult.FAILED) : new PrintPrimitive("action" + i, ActionResult.FINISHED);
        }
        TestWorkExecutor workExecuter = new TestWorkExecutor(actions);
        for (int loop = 0; loop < 4; ++loop) {
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            this.checkPrimitives(actions, res);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            this.checkPrimitives(actions, res);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            res[0] = res[0] + 1;
            this.checkPrimitives(actions, res);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            this.checkPrimitives(actions, res);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            this.checkPrimitives(actions, res);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            res[1] = res[1] + 1;
            this.checkPrimitives(actions, res);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            this.checkPrimitives(actions, res);
            System.out.println("Action2 will fail, reset");
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            res[2] = res[2] + 1;
            this.checkPrimitives(actions, res);
            System.out.println("Stack has been reseted.");
        }
    }

    @Test
    public void testSimpleC() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestSimpleC.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive action = new PrintPrimitive("action");
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{action});
        String[] paths = new String[]{"/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/A:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/A:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0"};
        this.assertEngineProgress(poshEngine, workExecuter, paths);
    }

    private void assertEngineProgress(PoshEngine engine, IWorkExecutor executor, String[] paths) {
        Iterator<String> expectedIt = Arrays.asList(paths).iterator();
        Iterator<Object> engineIt = Collections.emptyList().iterator();
        while (expectedIt.hasNext()) {
            String curPath = expectedIt.next();
            if (!engineIt.hasNext()) {
                PoshEngine.EvaluationResultInfo evaluationResult = engine.evaluatePlan(executor);
                PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)evaluationResult.result);
                engineIt = engine.getEvaluatedPaths().iterator();
            }
            LapPath enginePath = (LapPath)engineIt.next();
            PoshEngineTest.assertEquals((String)("Mismatched elements at path index " + Arrays.asList(paths).indexOf(curPath) + ", expected " + curPath + " but got " + enginePath.toString()), (Object)curPath, (Object)enginePath.toString());
        }
        PoshEngineTest.assertFalse((String)"Engine has extra paths", (boolean)engineIt.hasNext());
    }

    private void printPaths(List<LapPath> paths) {
        System.out.println("Evaluated paths:");
        for (LapPath path : paths) {
            System.out.println(path.toString());
        }
        System.out.println();
    }

    @Test
    @Ignore
    public void testSimpleCRetry() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestSimpleCRetry.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive action = new PrintPrimitive("action");
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{action});
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        if (action.triggered() != 0) {
            PoshEngineTest.fail((String)"Action was fired.");
        }
        int retries = 6;
        for (int i = 0; i < 6; ++i) {
            System.out.println("i" + i);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            if (action.triggered() != 0 + i) {
                PoshEngineTest.fail((String)"Action was fired.");
            }
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            if (action.triggered() != 0 + i) {
                PoshEngineTest.fail((String)"Action was fired.");
            }
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            if (action.triggered() != 1 + i) {
                PoshEngineTest.fail((String)"Action wasn't fired.");
            }
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
            if (action.triggered() == 1 + i) continue;
            PoshEngineTest.fail((String)"Action wasn't fired.");
        }
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        PoshEngineTest.assertEquals((long)0L, (long)poshEngine.getStackForDE("testDE").size());
    }

    @Test
    public void test011VarConstPassed2Primitive() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/011VarConstPassed2Primitive.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive murder = new PrintPrimitive("murder"){

            private boolean variableInContext(VariableContext ctx, String contextName, String value) {
                Object contextValue = ctx.getValue(contextName);
                return value == null ? contextValue == null : value.equals(contextValue);
            }

            private void assertVariableInContext(VariableContext ctx, String contextName, String value) {
                Assert.assertTrue((String)("Variable \"" + contextName + "\" is not \"" + value + "\", but " + ctx.getValue(contextName)), (boolean)this.variableInContext(ctx, contextName, value));
            }

            @Override
            public Object work(VariableContext ctx) {
                if (ctx.size() != 5) {
                    Assert.fail((String)("Expected 5 variables, is " + ctx.size()));
                }
                this.assertVariableInContext(ctx, "0", "killAllHumans");
                Assert.assertEquals((Object)ctx.getValue("1"), (Object)12.6);
                this.assertVariableInContext(ctx, "2", "Tomorrow");
                this.assertVariableInContext(ctx, "$method", "brutal");
                this.assertVariableInContext(ctx, "$baka", "Sekal");
                return super.work(ctx);
            }
        };
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), murder});
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        for (StackElement stackElement : poshEngine.getStackForDE("stay")) {
            VariableContext ctx = ((AbstractExecutor)stackElement.getExecutor()).ctx;
            System.out.println("Keys for " + stackElement.toString());
            for (String key : ctx.getKeys()) {
                System.out.println(" - \"" + key + "\" " + ctx.getValue(key));
            }
        }
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter).result);
        PoshEngineTest.assertTrue((murder.triggered() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void test012TestAPProcessing() throws IOException, ParseException {
        int i;
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/012TestAPProcessing.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive succeed = new PrintPrimitive("succeed", true);
        PrintPrimitive fail = new PrintPrimitive("fail", false);
        ITestPrimitive[] ok = new ITestPrimitive[]{new PrintPrimitive("ok1", ActionResult.FINISHED), new PrintPrimitive("ok2", ActionResult.FINISHED), new PrintPrimitive("ok3", ActionResult.FINISHED)};
        PrintPrimitive fail1 = new PrintPrimitive("fail1", ActionResult.FAILED);
        PrintPrimitive last = new PrintPrimitive("last", ActionResult.FINISHED);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{succeed, fail, ok[0], ok[1], ok[2], fail1, last});
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        for (i = 0; i < 3; ++i) {
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
            PoshEngineTest.assertTrue((ok[i].triggered() == 0 ? 1 : 0) != 0);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
            PoshEngineTest.assertTrue((ok[i].triggered() == 1 ? 1 : 0) != 0);
            PoshEngineTest.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        }
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        PoshEngineTest.assertTrue((fail1.triggered() == 0 ? 1 : 0) != 0);
        PoshEngineTest.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        PoshEngineTest.assertTrue((fail1.triggered() == 1 ? 1 : 0) != 0);
        PoshEngineTest.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        for (i = 0; i < 3; ++i) {
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
            PoshEngineTest.assertTrue((String)("ok" + i + " was triggered " + ok[i].triggered() + " != 1"), (ok[i].triggered() == 1 ? 1 : 0) != 0);
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
            PoshEngineTest.assertTrue((String)("ok" + i + " was triggered " + ok[i].triggered() + " != 2"), (ok[i].triggered() == 2 ? 1 : 0) != 0);
            PoshEngineTest.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        }
    }

    private void testPrimitiveExecutionOrder(PoshEngine engine, TestWorkExecutor executor, String[][] order) {
        HashMap<String, Integer> fired = new HashMap<String, Integer>();
        for (String key : executor.getPrimitives().keySet()) {
            fired.put(key, executor.getPrimitives().get(key).triggered());
        }
        for (int executionLoop = 0; executionLoop < order.length; ++executionLoop) {
            System.out.print(">>> Loop " + executionLoop + " [");
            for (String primitive : order[executionLoop]) {
                System.out.print(primitive + ", ");
            }
            System.out.println("]");
            PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)engine.evaluatePlan((IWorkExecutor)executor).result);
            for (String triggeredPrimitive : order[executionLoop]) {
                if (!fired.containsKey(triggeredPrimitive)) {
                    PoshEngineTest.fail((String)("Primitive \"" + triggeredPrimitive + "\" is not in executor list of primitives."));
                }
                fired.put(triggeredPrimitive, (Integer)fired.get(triggeredPrimitive) + 1);
            }
            for (String key : executor.getPrimitives().keySet()) {
                int supposedTriggerCount;
                int wasTriggeredCount = executor.getPrimitives().get(key).triggered();
                if (wasTriggeredCount == (supposedTriggerCount = ((Integer)fired.get(key)).intValue())) continue;
                PoshEngineTest.fail((String)("Primtives \"" + key + "\" is supposed to be triggered " + supposedTriggerCount + " times, but was " + wasTriggeredCount + " in loop " + executionLoop + "\n" + order[executionLoop]));
            }
        }
    }

    @Test
    public void test012New() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/012TestAPProcessing.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), new PrintPrimitive("ok1", ActionResult.FINISHED), new PrintPrimitive("ok2", ActionResult.FINISHED), new PrintPrimitive("ok3", ActionResult.FINISHED), new PrintPrimitive("fail1", ActionResult.FAILED), new PrintPrimitive("last", ActionResult.FINISHED)});
        String[][] primitivesOrder = new String[][]{{"fail", "succeed"}, {"fail", "succeed"}, {"fail", "succeed", "ok1"}, {"fail", "succeed"}, {"fail", "succeed", "ok2"}, {"fail", "succeed"}, {"fail", "succeed", "ok3"}, {"fail", "succeed"}, {"fail", "succeed", "fail1"}};
        for (int i = 0; i < 10; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test013TestDC() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/013DCSwitch.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive ok125 = new PrintPrimitive("ok125", true);
        PrintPrimitive ok3 = new PrintPrimitive("ok3", true);
        PrintPrimitive ok1234 = new PrintPrimitive("ok1234", true);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("fail", false), ok125, ok3, ok1234, new PrintPrimitive("action1", ActionResult.FAILED), new PrintPrimitive("action2", ActionResult.FINISHED), new PrintPrimitive("action3", ActionResult.FINISHED)});
        String[][] primitivesOrder1 = new String[][]{{"fail", "ok125"}, {"fail", "ok125", "action1"}};
        String[][] primitivesOrder2 = new String[][]{{"fail", "ok125"}, {"fail", "ok125", "action1"}};
        String[][] primitivesOrder3 = new String[][]{{"fail", "ok125", "ok3"}, {"fail", "ok125", "ok3", "action2"}};
        String[][] primitivesOrder4 = new String[][]{{"fail", "ok125", "ok3", "ok1234"}, {"fail", "ok125", "ok3", "ok1234", "action3"}};
        String[][] primitivesOrder5 = new String[][]{{"fail", "ok125"}, {"fail", "ok125", "action1"}};
        ok125.setReturnValue(true);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder1);
        ok125.setReturnValue(true);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder2);
        ok125.setReturnValue(false);
        ok3.setReturnValue(true);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder3);
        ok125.setReturnValue(false);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder4);
        ok125.setReturnValue(true);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(false);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder5);
    }

    @Test
    public void test014Comparison() throws IOException, ParseException {
        int i;
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/014Comparison.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ValuePrimitive<Integer> value = new ValuePrimitive<Integer>("value", 0);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{value, new PrintPrimitive("action", ActionResult.FAILED)});
        for (i = 0; i < 14; ++i) {
            value.setValue(i);
            PoshEngineTest.assertTrue((poshEngine.evaluatePlan((IWorkExecutor)executor).result != PoshEngine.EvaluationResult.GOAL_SATISFIED ? 1 : 0) != 0);
        }
        for (i = 14; i < 100; ++i) {
            value.setValue(i);
            PoshEngineTest.assertTrue((String)(" Loop " + i), (poshEngine.evaluatePlan((IWorkExecutor)executor).result == PoshEngine.EvaluationResult.GOAL_SATISFIED ? 1 : 0) != 0);
        }
    }

    @Test
    public void test015APDouble() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/015APdouble.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("action0", ActionResult.FINISHED), new PrintPrimitive("action1", ActionResult.FINISHED), new PrintPrimitive("action2", ActionResult.FINISHED), new PrintPrimitive("action3", ActionResult.FINISHED), new PrintPrimitive("action4", ActionResult.FINISHED)});
        String[][] primitivesOrder = new String[][]{new String[0], new String[0], {"action0"}, new String[0], new String[0], {"action1"}, new String[0], {"action2"}, new String[0], {"action3"}, new String[0], new String[0], {"action4"}, new String[0]};
        for (int i = 0; i < 10; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test016APDoubleFail() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/016APdoubleFail.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("action0", ActionResult.FINISHED), new PrintPrimitive("action1", ActionResult.FINISHED), new PrintPrimitive("action2", ActionResult.FAILED), new PrintPrimitive("action3", ActionResult.FINISHED), new PrintPrimitive("action4", ActionResult.FINISHED)});
        String[][] primitivesOrder = new String[][]{new String[0], new String[0], {"action0"}, new String[0], new String[0], {"action1"}, new String[0], {"action2"}};
        for (int i = 0; i < 10; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test017MultiCE() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/017MultiCE.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("tr1", false), new PrintPrimitive("tr2", true), new PrintPrimitive("tr3", false), new PrintPrimitive("action", ActionResult.FINISHED), new PrintPrimitive("action0", ActionResult.FINISHED), new PrintPrimitive("action1", ActionResult.FINISHED)});
        String[] traverseChoices = new String[]{"/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/S:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1/S:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1/A:0/AP:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1/A:0/AP:0/A:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1/A:0/AP:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1/A:0/AP:0/A:1", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1/A:0/AP:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:1", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0"};
        for (int i = 0; i < 20; ++i) {
            this.assertEngineProgress(poshEngine, executor, traverseChoices);
        }
    }

    @Test
    public void test018MultiC() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/018MultiC.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ValuePrimitive<Boolean> tr1 = new ValuePrimitive<Boolean>("tr1", true);
        ValuePrimitive<Boolean> tr2 = new ValuePrimitive<Boolean>("tr2", true);
        ValuePrimitive<Boolean> action = new ValuePrimitive<Boolean>("action", true);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{tr1, tr2, action});
        String[] traverseTwoCompetences = new String[]{"/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/A:0/C:1", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/A:0/C:1/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/A:0/C:1/CE:0/A:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/A:0/C:1/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0/A:0/C:1", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0/CE:0", "/P:0/DC:0/DE:0", "/P:0/DC:0/DE:0/A:0/C:0"};
        for (int i = 0; i < 10; ++i) {
            this.assertEngineProgress(poshEngine, executor, traverseTwoCompetences);
        }
    }

    @Test
    public void test020SenseCtx() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/020SenseCtx.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        StateWorkExecutor stateWorkExecutor = new StateWorkExecutor();
        stateWorkExecutor.addAction("doNothing", new IAction(){

            public void init(VariableContext ctx) {
            }

            public ActionResult run(VariableContext ctx) {
                return ActionResult.FINISHED;
            }

            public void done(VariableContext ctx) {
            }
        });
        stateWorkExecutor.addSense("playerClose", new ISense(){

            public Object query(VariableContext ctx) {
                if (ctx.size() != 3) {
                    Assert.fail((String)("Size is not 3, but " + ctx.size()));
                }
                Assert.assertEquals((Object)ctx.getValue("0"), (Object)12.4);
                Assert.assertEquals((Object)ctx.getValue("$second"), (Object)"brutal");
                Assert.assertEquals((Object)ctx.getValue("$third"), (Object)"lala");
                return true;
            }
        });
        poshEngine.evaluatePlan((IWorkExecutor)stateWorkExecutor);
        poshEngine.evaluatePlan((IWorkExecutor)stateWorkExecutor);
    }

    @Test
    public void test021TestEqualTrue() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/021TestEqualTrue.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive something = new PrintPrimitive("something", ActionResult.FINISHED);
        PrintPrimitive nothing = new PrintPrimitive("doNothing", ActionResult.FINISHED);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), something, nothing});
        String[][] primitivesOrder = new String[][]{{"fail", "succeed"}, {"fail", "succeed", "something"}};
        for (int i = 0; i < 20; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test022TestAdopt() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/022TestAdopt.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive action0 = new PrintPrimitive("action0", ActionResult.FINISHED);
        PrintPrimitive action1 = new PrintPrimitive("action1", ActionResult.FINISHED);
        PrintPrimitive action2 = new PrintPrimitive("action2", ActionResult.FINISHED);
        PrintPrimitive succeed0 = new PrintPrimitive("succeed0", true);
        PrintPrimitive succeed1 = new PrintPrimitive("succeed1", true);
        PrintPrimitive succeed2 = new PrintPrimitive("succeed2", true);
        PrintPrimitive fail = new PrintPrimitive("fail", false);
        PrintPrimitive sometime = new PrintPrimitive("sometime", false);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{succeed0, succeed1, succeed2, fail, sometime, action0, action1, action2});
        System.out.println("--- CYCLE ---");
        System.out.println("put testC1 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        System.out.println("--- CYCLE ---");
        System.out.println("put ce2 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        System.out.println("--- CYCLE ---");
        System.out.println("put adoptTestC2 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        System.out.println("--- CYCLE ---");
        System.out.println("put testC2 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        System.out.println("--- CYCLE ---");
        System.out.println("put ce3 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        System.out.println("--- CYCLE ---");
        System.out.println("put action2 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        System.out.println("--- CYCLE ---");
        System.out.println("put execute action2, delete it from stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        PoshEngineTest.assertTrue((action2.triggered() == 1 ? 1 : 0) != 0);
        System.out.println("--- CYCLE ---");
        System.out.println("let 'morePrior' drive to interrupt previous drive");
        sometime.setReturnValue(true);
        System.out.println("interrupt 'default' drive, put action0 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        PoshEngineTest.assertTrue((action2.triggered() == 1 ? 1 : 0) != 0);
        System.out.println("--- CYCLE ---");
        System.out.println("execute action0, remove it from stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        PoshEngineTest.assertTrue((action0.triggered() == 1 ? 1 : 0) != 0);
        PoshEngineTest.assertTrue((action2.triggered() == 1 ? 1 : 0) != 0);
        System.out.println("--- CYCLE ---");
        System.out.println("return to 'default' drive");
        sometime.setReturnValue(false);
        System.out.println("drive's stack should already be cut back to 'adoptTestC2', execute 'adoptTestC2' put testC2 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        PoshEngineTest.assertTrue((action0.triggered() == 1 ? 1 : 0) != 0);
        PoshEngineTest.assertTrue((action2.triggered() == 1 ? 1 : 0) != 0);
        System.out.println("--- CYCLE ---");
        System.out.println("put ce3 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        PoshEngineTest.assertTrue((action0.triggered() == 1 ? 1 : 0) != 0);
        PoshEngineTest.assertTrue((action2.triggered() == 1 ? 1 : 0) != 0);
        System.out.println("--- CYCLE ---");
        System.out.println("put action2 on stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        PoshEngineTest.assertTrue((action0.triggered() == 1 ? 1 : 0) != 0);
        PoshEngineTest.assertTrue((action2.triggered() == 1 ? 1 : 0) != 0);
        System.out.println("--- CYCLE ---");
        System.out.println("execute action2, remove it from stack");
        PoshEngineTest.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor).result);
        this.printDrives(poshEngine);
        PoshEngineTest.assertTrue((action0.triggered() == 1 ? 1 : 0) != 0);
        PoshEngineTest.assertTrue((action2.triggered() == 2 ? 1 : 0) != 0);
    }

    private void printDrives(PoshEngine poshEngine) {
        for (int i = 0; i < poshEngine.getDECount(); ++i) {
            System.out.println("Stack(" + poshEngine.getDEName(i) + "): " + poshEngine.getStackForDE(i));
        }
    }

    private class ValuePrimitive<T>
    implements ITestPrimitive {
        private String name;
        private T value;
        private int triggered = 0;

        public ValuePrimitive(String name, T initialValue) {
            this.name = name;
            this.value = initialValue;
        }

        public void setValue(T value) {
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object work(VariableContext ctx) {
            ++this.triggered;
            return this.value;
        }

        @Override
        public int triggered() {
            return this.triggered;
        }
    }
}

