package cz.cuni.amis.pogamut.sposh.engine;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.FireResult.Type;

/**
 * Predecesor of all executors, basically provides only logging infrastructure.
 * @author Honza
 */
class AbstractExecutor {
    protected VariableContext ctx;
    protected final Logger log;

    protected AbstractExecutor(VariableContext ctx, Logger log) {
        this.ctx = ctx;
        this.log = log;
    }

    public void fine(String msg) {
        if (log != null)
            log.fine(msg);
    }

    public void info(String msg) {
        if (log != null)
            log.info(msg);
    }
    
    public void warning(String msg) {
        if (log != null)
            log.warning(msg);
    }
    
    protected StackElement<ADExecutor> getElementAD(PoshPlan plan, PrimitiveCall adaptCall) {
    	String actionName = adaptCall.getName();
    	for (Adopt ap : plan.getAdopts()) {
            if (actionName.equals(ap.getName())) {
                return new StackElement<ADExecutor>(
                			Adopt.class, 
                			actionName, 
                			new ADExecutor(plan, ap, new VariableContext(ctx, adaptCall.getParameters(), ap.getParameters()), log)
                	   );
            }
        }
    	return null;
    }
    
    protected StackElement<APExecutor> getElementAP(PoshPlan plan, PrimitiveCall actionCall) {
    	String actionName = actionCall.getName();
    	for (ActionPattern ap : plan.getActionPatterns()) {
            if (actionName.equals(ap.getName())) {
                return new StackElement<APExecutor>(
                			ActionPattern.class, 
                			actionName, 
                			new APExecutor(plan, ap, FireResult.Type.SURFACE, new VariableContext(ctx, actionCall.getParameters(), ap.getParameters()), log)
                	   );
            }
        }
    	return null;
    }
    
    protected StackElement<CExecutor> getElementC(PoshPlan plan, PrimitiveCall competenceCall) {
    	String actionName = competenceCall.getName();
	    for (Competence c : plan.getCompetences()) {
	        if (actionName.equals(c.getName())) {
	            return new StackElement<CExecutor>(Competence.class, 
	            		                           actionName, 
	            		                           new CExecutor(plan, c, new VariableContext(ctx, competenceCall.getParameters(), c.getParameters()), log)
	            );
	        }
	    }
	    return null;
    }
    
    protected StackElement<ActionExecutor> getElementAction(PoshPlan plan, PrimitiveCall actionCall, 
    													    FireResult.Type finishedResult, FireResult.Type runningResult, FireResult.Type runningOnceResult, FireResult.Type failedResult) {
    	String actionName = actionCall.getName();
    	return new StackElement<ActionExecutor>(TriggeredAction.class, actionName,
								                new ActionExecutor(
								                    actionCall,
								                    finishedResult, 
								                    runningResult,
								                    runningOnceResult,
								                    failedResult,
								                    null,
								                    null,
								                    null,
								                    null,
								                    new VariableContext(ctx, actionCall.getParameters()), log)
								        		);
    }
    
    protected StackElement<ActionExecutor> getElementAction(
    		PoshPlan plan, PrimitiveCall actionCall, 
		    FireResult.Type finishedResult, FireResult.Type runningResult, FireResult.Type runningOnceResult,  FireResult.Type failedResult,
		    Runnable finishedResultCallback, Runnable runningResultCallback, Runnable runningOnceResultCallback, Runnable failedResultCallback
    ) {
		String actionName = actionCall.getName();
		return new StackElement<ActionExecutor>(TriggeredAction.class, actionName,
												new ActionExecutor(
															actionCall,
															finishedResult, 
															runningResult,
															runningOnceResult,
															failedResult,
															finishedResultCallback,
															runningResultCallback,
															runningOnceResultCallback,
															failedResultCallback,
															new VariableContext(ctx, actionCall.getParameters()), log)
												);
	}
    
    protected StackElement getElement(PoshPlan plan, PrimitiveCall actionCall, 
		    						  FireResult.Type actionFinishedResult, FireResult.Type actionRunningResult, FireResult.Type actionRunningOnceResult, FireResult.Type actionFailedResult
	) {
    	return getElement(plan, actionCall, actionFinishedResult, actionRunningResult, actionRunningOnceResult, actionFailedResult, null, null, null, null);
    }
    
    protected StackElement getElement(PoshPlan plan, PrimitiveCall actionCall, 
			  						  FireResult.Type actionFinishedResult, FireResult.Type actionRunningResult, FireResult.Type actionRunningOnceResult , FireResult.Type actionFailedResult,
			  						  Runnable finishedResultCallback, Runnable runningResultCallback, Runnable runningOnceCallback, Runnable failedResultCallback
    ) {
    	StackElement stackElement = getElementC(plan, actionCall);
    	
		if (stackElement == null) {
			stackElement = getElementAP(plan, actionCall);
			if (stackElement == null) {
				stackElement = getElementAD(plan, actionCall);
				if (stackElement == null) {
					stackElement = getElementAction(plan, actionCall, 
													actionFinishedResult, 
													actionRunningResult,
													actionRunningOnceResult,
													actionFailedResult,
													finishedResultCallback,
													runningResultCallback,
													runningOnceCallback,
													failedResultCallback
				    );
				}
			}
		}
		
		return stackElement;    	
    }

    /**
     * Get variable context of this executor.
     * TODO: should this be public?
     */
    public VariableContext getVariableContext() {
        return ctx;
    }
}
