/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class PoshPlan
extends PoshDummyElement<PoshPlan, PoshPlan> {
    private String name = "";
    private String author = "";
    private String info = "";
    private final DriveCollection dc;
    private final List<ActionPattern> aps = new ArrayList<ActionPattern>();
    private final List<ActionPattern> apsUm = Collections.unmodifiableList(this.aps);
    private final List<Competence> cs = new ArrayList<Competence>();
    private final List<Competence> csUm = Collections.unmodifiableList(this.cs);
    private final List<Adopt> ads = new ArrayList<Adopt>();
    private final List<Adopt> adsUm = Collections.unmodifiableList(this.ads);
    public static final DataFlavor dataFlavor = new DataFlavor(PoshPlan.class, "posh_tree_root");
    public static final String PROP_NAME = "posh-plan-name";
    public static final String PROP_AUTHOR = "posh-plan-author";
    public static final String PROP_INFO = "posh-plan-info";

    PoshPlan(String driveCollectionName) {
        this.dc = LapElementsFactory.createDriveCollection(driveCollectionName);
        this.dc.setParent(this);
    }

    private Set<String> getReachableActionNames() {
        HashSet<String> reachableNames = new HashSet<String>();
        for (DriveElement drive : this.dc.getDrives()) {
            String driveActionName = drive.getAction().getName();
            if (this.isAP(driveActionName)) {
                ActionPattern actionPattern = this.getAP(driveActionName);
                reachableNames.addAll(this.getActionPatternActionNames(actionPattern));
                continue;
            }
            if (this.isC(driveActionName)) {
                Competence competence = this.getC(driveActionName);
                reachableNames.addAll(this.getCompetenceActionNames(competence));
                continue;
            }
            reachableNames.add(driveActionName);
        }
        return reachableNames;
    }

    private Set<String> getCompetenceActionNames(Competence c) {
        throw new UnsupportedOperationException();
    }

    private Set<String> getActionPatternActionNames(ActionPattern ap) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getActionsNames() {
        HashSet<String> actionNames = new HashSet<String>();
        List<TriggeredAction> actions = this.getActions();
        for (TriggeredAction action : actions) {
            actionNames.add(action.getName());
        }
        return actionNames;
    }

    public List<TriggeredAction> getActions() {
        List<TriggeredAction> references = this.getAllReferences();
        LinkedList<TriggeredAction> actions = new LinkedList<TriggeredAction>();
        for (TriggeredAction reference : references) {
            String referenceName = reference.getName();
            if (this.isAP(referenceName) || this.isC(referenceName) || this.isAD(referenceName)) continue;
            actions.add(reference);
        }
        return actions;
    }

    public List<TriggeredAction> getAllReferences() {
        LinkedList<TriggeredAction> references = new LinkedList<TriggeredAction>();
        for (DriveElement drive : this.dc.getDrives()) {
            references.add(drive.getAction());
        }
        for (Competence competence : this.csUm) {
            for (CompetenceElement competenceElement : competence.getChildDataNodes()) {
                references.add(competenceElement.getAction());
            }
        }
        for (ActionPattern actionPattern : this.apsUm) {
            for (TriggeredAction action : actionPattern.getActions()) {
                references.add(action);
            }
        }
        for (Adopt adopt : this.adsUm) {
            references.add(adopt.getAdoptedElement());
        }
        return references;
    }

    public Set<String> getSensesNames() {
        HashSet<String> senseNames = new HashSet<String>();
        this.addTriggerSenseNames(this.dc.getGoal(), senseNames);
        for (DriveElement drive : this.dc.getDrives()) {
            this.addTriggerSenseNames(drive.getTrigger(), senseNames);
        }
        for (Competence competence : this.csUm) {
            for (CompetenceElement competenceElement : competence.getChildDataNodes()) {
                this.addTriggerSenseNames(competenceElement.getTrigger(), senseNames);
            }
        }
        for (Adopt adopt : this.adsUm) {
            this.addTriggerSenseNames(adopt.getExitCondition(), senseNames);
        }
        return senseNames;
    }

    private void addTriggerSenseNames(Trigger<?> trigger, Set<String> senseNames) {
        for (Sense triggerSense : trigger) {
            senseNames.add(triggerSense.getName());
        }
    }

    public boolean isC(String name) {
        return this.getC(name) != null;
    }

    public Competence getC(String name) {
        for (Competence c : this.getCompetences()) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public boolean isAP(String name) {
        return this.getAP(name) != null;
    }

    public ActionPattern getAP(String name) {
        for (ActionPattern ap : this.getActionPatterns()) {
            if (!ap.getName().equals(name)) continue;
            return ap;
        }
        return null;
    }

    public boolean isAD(String name) {
        return this.getAD(name) != null;
    }

    public Adopt getAD(String name) {
        for (Adopt ad : this.getAdopts()) {
            if (!ad.getName().equals(name)) continue;
            return ad;
        }
        return null;
    }

    public boolean isUniqueAPorComp(String testedName) {
        return !this.isAP(testedName) && !this.isC(testedName) && !this.isAD(testedName);
    }

    public void addCompetence(Competence competence) throws DuplicateNameException, CycleException {
        if (!this.isUniqueAPorComp(competence.getName())) {
            throw DuplicateNameException.create(competence.getName());
        }
        PoshPlan orgParent = (PoshPlan)competence.getParent();
        this.cs.add(competence);
        competence.setParent(this);
        if (this.isCycled()) {
            competence.setParent(orgParent);
            this.cs.remove(competence);
            throw CycleException.createFromName(competence.getName());
        }
        this.emitChildNode(competence);
    }

    public void addAdopt(Adopt adopt) throws DuplicateNameException, CycleException {
        if (!this.isUniqueAPorComp(adopt.getName())) {
            throw DuplicateNameException.create(adopt.getName());
        }
        PoshPlan orgParent = (PoshPlan)adopt.getParent();
        this.ads.add(adopt);
        adopt.setParent(this);
        if (this.isCycled()) {
            adopt.setParent(orgParent);
            this.ads.remove(adopt);
            throw CycleException.createFromName(adopt.getName());
        }
        this.emitChildNode(adopt);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        assert (name != null);
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(PROP_NAME, oldName, name);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        assert (author != null);
        String oldAuthor = this.author;
        this.author = author;
        this.firePropertyChange(PROP_AUTHOR, oldAuthor, author);
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        assert (info != null);
        String oldInfo = this.info;
        this.info = info;
        this.firePropertyChange(PROP_INFO, oldInfo, info);
    }

    public List<Competence> getCompetences() {
        return this.csUm;
    }

    public void addActionPattern(ActionPattern actionPattern) throws DuplicateNameException, CycleException {
        if (!this.isUniqueAPorComp(actionPattern.getName())) {
            throw new DuplicateNameException("Action pattern '" + actionPattern.getName() + "' has duplicate name in POSH plan.");
        }
        PoshPlan orgParent = (PoshPlan)actionPattern.getParent();
        this.aps.add(actionPattern);
        actionPattern.setParent(this);
        if (this.isCycled()) {
            actionPattern.setParent(orgParent);
            this.aps.remove(actionPattern);
            throw CycleException.createFromName(this.name);
        }
        this.emitChildNode(actionPattern);
    }

    public List<Adopt> getAdopts() {
        return this.adsUm;
    }

    public List<ActionPattern> getActionPatterns() {
        return this.apsUm;
    }

    public DriveCollection getDriveCollection() {
        return this.dc;
    }

    public boolean isCycled() {
        for (ActionPattern apNode : this.aps) {
            if (!this.findCycle(apNode, new HashSet<String>())) continue;
            return true;
        }
        for (Competence compNode : this.cs) {
            if (!this.findCycle(compNode, new HashSet<String>())) continue;
            return true;
        }
        return false;
    }

    private boolean findCycle(ActionPattern apNode, Set<String> set) {
        if (set.contains(apNode.getName())) {
            return true;
        }
        set.add(apNode.getName());
        for (TriggeredAction action : apNode.getActions()) {
            ActionPattern actionAP = this.getAP(action.getName());
            if (actionAP != null && this.findCycle(actionAP, set)) {
                return true;
            }
            Competence actionComp = this.getC(action.getName());
            if (actionComp == null || !this.findCycle(actionComp, set)) continue;
            return true;
        }
        set.remove(apNode.getName());
        return false;
    }

    private boolean findCycle(Competence compNode, Set<String> set) {
        if (set.contains(compNode.getName())) {
            return true;
        }
        set.add(compNode.getName());
        for (CompetenceElement element : compNode.getChildDataNodes()) {
            TriggeredAction action = element.getAction();
            ActionPattern actionAP = this.getAP(action.getName());
            if (actionAP != null && this.findCycle(actionAP, set)) {
                return true;
            }
            Competence actionComp = this.getC(action.getName());
            if (actionComp == null || !this.findCycle(actionComp, set)) continue;
            return true;
        }
        set.remove(compNode.getName());
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        if (!(this.name.isEmpty() && this.author.isEmpty() && this.info.isEmpty())) {
            sb.append("\n\t(documentation \"");
            sb.append(this.name.replace("\"", ""));
            sb.append("\" \"");
            sb.append(this.author.replace("\"", ""));
            sb.append("\" \"");
            sb.append(this.info.replace("\"", ""));
            sb.append("\")\n");
        }
        for (Competence competence : this.cs) {
            sb.append('\n');
            sb.append(competence.toString());
        }
        for (ActionPattern actionPattern : this.aps) {
            sb.append('\n');
            sb.append(actionPattern.toString());
        }
        sb.append('\n');
        sb.append(this.dc.toString());
        sb.append("\n)");
        return sb.toString();
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>();
        children.addAll(this.cs);
        children.addAll(this.aps);
        children.add(this.dc);
        return children;
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    public void removeCompetence(Competence removeCompetence) {
        assert (this.csUm.contains(removeCompetence));
        int removedCIndex = this.csUm.indexOf(removeCompetence);
        this.cs.remove(removeCompetence);
        removeCompetence.setParent(null);
        this.emitChildDeleted(removeCompetence, removedCIndex);
    }

    public void removeActionPattern(ActionPattern ap) {
        assert (this.apsUm.contains(ap));
        int removedAPIndex = this.apsUm.indexOf(ap);
        this.aps.remove(ap);
        ap.setParent(null);
        this.emitChildDeleted(ap, removedAPIndex);
    }

    public void synchronize(PoshPlan other) {
        Sense[] goalSenses;
        Competence[] compArray;
        ActionPattern[] apArray;
        for (ActionPattern ap : apArray = this.aps.toArray(new ActionPattern[this.aps.size()])) {
            this.removeActionPattern(ap);
        }
        for (Competence c : compArray = this.cs.toArray(new Competence[this.cs.size()])) {
            this.removeCompetence(c);
        }
        for (Sense goalSense : goalSenses = this.dc.getGoal().toArray(new Sense[0])) {
            this.dc.getGoal().remove(goalSense);
        }
        try {
            DriveElement[] originalDrives = this.dc.getDrives().toArray(new DriveElement[0]);
            ArrayList<DriveElement> allDrives = new ArrayList<DriveElement>();
            allDrives.addAll(this.dc.getDrives());
            allDrives.addAll(other.dc.getDrives());
            String syncDriveName = PoshPlan.getUnusedName("temporaryDriveSyncName", allDrives);
            DriveElement syncDrive = LapElementsFactory.createDriveElementNoTriggers(syncDriveName);
            this.dc.addDrive(syncDrive);
            for (DriveElement drive : originalDrives) {
                this.dc.removeDrive(drive);
            }
            for (DriveElement drive : other.dc.getDrives()) {
                this.dc.addDrive(LapElementsFactory.createDriveElement(drive));
            }
            this.dc.removeDrive(syncDrive);
            for (ActionPattern ap : other.apsUm) {
                this.addActionPattern(LapElementsFactory.createActionPattern(ap));
            }
            for (Competence c : other.csUm) {
                this.addCompetence(LapElementsFactory.createCompetence(c));
            }
            for (Sense oGoalSense : other.dc.getGoal()) {
                this.dc.getGoal().add(LapElementsFactory.createSense(oGoalSense));
            }
        }
        catch (DuplicateNameException ex) {
            throw new FubarException("Original tree should be correct thus new one should be too.", ex);
        }
        catch (CycleException ex) {
            throw new FubarException("Original tree should be correct thus new one should be too.", ex);
        }
    }
}

