/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LapElementsFactory {
    public static String DEFAULT_ACTION = "doNothing";
    public static String DEFAULT_TRIGGER_SENSE = "succeed";
    public static String DEFAULT_DRIVE_COLLECTION_NAME = "life";

    public static Competence createCompetence(String name, String ... choices) throws DuplicateNameException {
        ArrayList<CompetenceElement> elements = new ArrayList<CompetenceElement>(choices.length);
        for (String choice : choices) {
            elements.add(LapElementsFactory.createCompetenceElement(choice));
        }
        return new Competence(name, new FormalParameters(), elements);
    }

    public static DriveElement createDriveElement(String driveName) {
        return new DriveElement(driveName, Arrays.asList(new Sense(DEFAULT_TRIGGER_SENSE)), new PrimitiveCall(DEFAULT_ACTION), Freq.INFINITE, "");
    }

    public static DriveElement createDriveElementNoTriggers(String name) {
        return new DriveElement(name, Collections.<Sense>emptyList(), new PrimitiveCall(DEFAULT_ACTION), Freq.INFINITE, "");
    }

    public static CompetenceElement createCompetenceElement(String name) {
        return new CompetenceElement(name, Collections.<Sense>emptyList(), new PrimitiveCall(DEFAULT_ACTION), -1, "");
    }

    public static Sense createSense(String name) {
        return new Sense(name);
    }

    public static TriggeredAction createAction() {
        return new TriggeredAction(DEFAULT_ACTION);
    }

    public static TriggeredAction createAction(String name) {
        return new TriggeredAction(name);
    }

    public static TriggeredAction createAction(PrimitiveCall call) {
        return new TriggeredAction(new PrimitiveCall(call));
    }

    public static ActionPattern createActionPattern(String name) {
        return new ActionPattern(name, new FormalParameters(), Collections.<TriggeredAction>emptyList(), "");
    }

    public static ActionPattern createActionPattern(String name, TriggeredAction ... actions) {
        return new ActionPattern(name, new FormalParameters(), Arrays.asList(actions), "");
    }

    public static ActionPattern createActionPattern(String name, FormalParameters params) {
        return new ActionPattern(name, params, Collections.<TriggeredAction>emptyList(), "");
    }

    public static ActionPattern createActionPattern(String name, FormalParameters params, List<TriggeredAction> actions) {
        return new ActionPattern(name, params, actions, "");
    }

    public static ActionPattern createActionPattern(ActionPattern ap) {
        String serializedActionPattern = ap.toString();
        try {
            return new PoshParser(new StringReader(serializedActionPattern.substring(serializedActionPattern.indexOf(40) + 1))).actionPattern();
        }
        catch (ParseException ex) {
            String msg = "Tried to serialize and deserialize action pattern as copy constructor: " + serializedActionPattern;
            Logger.getLogger(LapElementsFactory.class.getName()).log(Level.SEVERE, msg, ex);
            throw new FubarException(msg, ex);
        }
    }

    public static Competence createCompetence(Competence c) {
        String serializedCompetence = c.toString();
        try {
            return new PoshParser(new StringReader(serializedCompetence.substring(serializedCompetence.indexOf(40) + 1))).competence();
        }
        catch (ParseException ex) {
            String msg = "Tried to serialize and deserialize competence as copy constructor: " + serializedCompetence;
            Logger.getLogger(LapElementsFactory.class.getName()).log(Level.SEVERE, msg, ex);
            throw new FubarException(msg, ex);
        }
    }

    public static DriveElement createDriveElement(DriveElement drive) {
        String serializedDrive = drive.toString();
        try {
            return new PoshParser(new StringReader(serializedDrive)).driveElement(new FormalParameters());
        }
        catch (ParseException ex) {
            String msg = "Tried to serialize and deserialize drive as copy constructor: " + serializedDrive;
            Logger.getLogger(LapElementsFactory.class.getName()).log(Level.SEVERE, msg, ex);
            throw new FubarException(msg, ex);
        }
    }

    public static Sense createSense(Sense sense) {
        String serializedSense = sense.toString();
        try {
            return new PoshParser(new StringReader(serializedSense)).fullSense(new FormalParameters());
        }
        catch (ParseException ex) {
            String msg = "Tried to serialize and deserialize sense as copy constructor: " + serializedSense;
            Logger.getLogger(LapElementsFactory.class.getName()).log(Level.SEVERE, msg, ex);
            throw new FubarException(msg, ex);
        }
    }

    public static DriveCollection createDriveCollection() {
        return new DriveCollection("placeholder");
    }

    public static DriveCollection createDriveCollection(String driveCollectionName) {
        return new DriveCollection(driveCollectionName);
    }

    public static CompetenceElement createCompetenceElement(String name, List<Sense> triggerSenses, String actionName) {
        return new CompetenceElement(name, triggerSenses, new PrimitiveCall(actionName), -1, "");
    }

    public static DriveElement createDriveElement(String name, List<Sense> triggerSenses, PrimitiveCall actionCall, Freq freq, String comment) {
        return new DriveElement(name, triggerSenses, actionCall, freq, comment);
    }

    public static PoshPlan createPlan(String dcName) {
        return new PoshPlan(dcName);
    }

    static PoshPlan createPlan() {
        return LapElementsFactory.createPlan(DEFAULT_DRIVE_COLLECTION_NAME);
    }

    public static TriggeredAction createAction(TriggeredAction original) {
        return new TriggeredAction(original.getActionCall());
    }
}

