/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.APExecutor;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PrimitiveExecutor;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

class CEExecutor
extends AbstractExecutor
implements ElementExecutor {
    private PoshPlan plan;
    private Sense.SenseCall actionCall;
    private String name;
    private SenseListExecutor trigger;
    private int retries = 0;
    private int maxRetries;
    private TriggerResult result;
    private boolean actionCalled = false;

    CEExecutor(PoshPlan plan, CompetenceElement ce, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.name = ce.getName();
        this.trigger = new SenseListExecutor(ce.getTriggerSenses(), ctx, log);
        this.maxRetries = ce.getRetries() == null ? -1 : ce.getRetries();
        this.plan = plan;
        this.actionCall = ce.getAction().getActionCall();
    }

    private StackElement createActionExecutor(PoshPlan plan, Sense.SenseCall actionCall) {
        String actionName = actionCall.getName();
        for (ActionPattern ap : plan.getActionPatterns()) {
            if (!actionName.equals(ap.getName())) continue;
            return new StackElement<APExecutor>(ActionPattern.class, actionName, new APExecutor(plan, ap, FireResult.Type.SURFACE, new VariableContext(this.ctx, actionCall.getParameters(), ap.getParameters()), this.log));
        }
        for (Competence c : plan.getCompetences()) {
            if (!actionName.equals(c.getName())) continue;
            return new StackElement<CExecutor>(Competence.class, actionName, new CExecutor(plan, c, new VariableContext(this.ctx, actionCall.getParameters(), c.getParameters()), this.log));
        }
        return new StackElement<PrimitiveExecutor>(TriggeredAction.class, actionName, new PrimitiveExecutor(actionCall, FireResult.Type.SURFACE, FireResult.Type.FAILED, new VariableContext(this.ctx, actionCall.getParameters()), this.log));
    }

    TriggerResult isReady(IWorkExecutor workExecuter) {
        this.fine("isReady? " + this.retries + "/" + this.maxRetries);
        this.result = this.maxRetries < 0 || this.retries < this.maxRetries ? this.trigger.fire(workExecuter, true) : new TriggerResult(false);
        return this.result;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (this.actionCalled) {
            this.actionCalled = false;
            return new FireResult(FireResult.Type.SURFACE);
        }
        ++this.retries;
        this.actionCalled = true;
        return new FireResult(FireResult.Type.FOLLOW, this.createActionExecutor(this.plan, this.actionCall));
    }

    String getName() {
        return this.name;
    }

    @Override
    public TriggerResult getTriggerResult() {
        return this.result;
    }
}

