/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ElementList;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Goal
extends PoshDummyElement {
    private ElementList<Sense> _sense_list;
    public static final DataFlavor dataFlavor = new DataFlavor(Goal.class, "goal");

    static Goal createFail() {
        return new Goal(new Sense("fail"));
    }

    static Goal createEmpty() {
        return new Goal(new ElementList<Sense>());
    }

    public Goal(Sense sense) {
        sense.setParent(this);
        this._sense_list = new ElementList();
        this._sense_list.add(sense);
    }

    public Goal(ElementList<Sense> sense_list) {
        for (Sense sense : sense_list) {
            sense.setParent(this);
        }
        this._sense_list = sense_list;
    }

    public void addSense(Sense sense) {
        sense.setParent(this);
        this._sense_list.add(sense);
        this.emitChildNode(sense);
    }

    public void addUserSense(Sense sense) {
        if (this._sense_list.size() == 1 && ("succeed".equals(((Sense)this._sense_list.get(0)).getSenseName()) || "fail".equals(((Sense)this._sense_list.get(0)).getSenseName()))) {
            ((Sense)this._sense_list.get(0)).changeTo(sense);
        } else {
            this.addSense(sense);
        }
    }

    public String toString() {
        return "(goal " + this._sense_list.toString() + ")";
    }

    public List<PoshElement> getChildDataNodes() {
        return new ArrayList<PoshElement>(this._sense_list);
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return this.moveNodeInList(this._sense_list, child, relativePosition);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (!(newChild instanceof Sense)) {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
        this.addSense((Sense)newChild);
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this._sense_list.contains(childNode)) {
            if (this._sense_list.size() <= 1) {
                this.addSense(new Sense("fail"));
            }
            this._sense_list.remove(childNode);
            childNode.remove();
        }
    }

    public synchronized List<Sense> getSenses() {
        return Collections.unmodifiableList(this._sense_list);
    }
}

