package cz.cuni.amis.pogamut.sposh.elements;

import java.util.ArrayList;
import java.util.List;

/**
 * This is a factory class that can be used to create various elements.
 *
 * @author HonzaH
 */
public class LapElementsFactory {

    /**
     * Name of action that will be used unless user specifies a name of action
     * that should be used.
     */
    public static String DEFAULT_ACTION = "doNothing";
    /**
     * Name of trigger that will be used unless user specifies some other
     * trigger in the arguments.
     */
    public static String DEFAULT_TRIGGER_SENSE = "succeed";

    /**
     * Create a new competence with multiple choices. The choices have default
     * action and trigger.
     *
     * @param name name of new competence
     * @param choices unique sequence of choices for this competence
     * @return created competence
     */
    public static Competence createCompetence(String name, String... choices) {
        List<CompetenceElement> elements = new ArrayList<CompetenceElement>(choices.length);

        for (String choice : choices) {
            elements.add(new CompetenceElement(choice, new Sense(DEFAULT_TRIGGER_SENSE), DEFAULT_ACTION, null));
        }

        return new Competence(name, new FormalParameters(), elements);
    }

    /**
     * Create new drive with default trigger and action.
     *
     * @param driveName name of the drive
     */
    public static DriveElement createDriveElement(String driveName) {
        return new DriveElement(driveName, new Triggers(new Sense(DEFAULT_TRIGGER_SENSE)), DEFAULT_ACTION, null);
    }

    /**
     * Create new drive with specified name and empty list of triggers and
     * default action.
     *
     * @param name name of created drive element
     */
    public static DriveElement createDriveElementNoTriggers(String name) {
        return new DriveElement(name, new Triggers(), DEFAULT_ACTION, null);
    }

    /**
     * Create new competence element with trigger of deafult sense and default action.
     * @param name name of competence element
     * @return created element
     */
    public static CompetenceElement createCompetenceElement(String name) {
        return new CompetenceElement(name, new Sense(DEFAULT_TRIGGER_SENSE), DEFAULT_ACTION, null);
    }

    /**
     * Create new sense.
     * @param name name of the sense
     * @return created sense
     */
    public static Sense createSense(String name) {
        return new Sense(name);
    }
}
