package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

/**
 * Executor for CE. 
 * @author Honza
 */
class CEExecutor extends AbstractExecutor implements ElementExecutor {
    private PoshPlan plan;
    private Sense.SenseCall actionCall;
    private String name;
    private SenseListExecutor trigger;
    private int retries = 0;
    private int maxRetries;
    private TriggerResult result;
    
    /**
     * Create competence executor.
     * @param plan plan that will be used to resolve primitives
     * @param ce competence element that is going to be executed
     * @param ctx variable context of competence element
     * @param log logger to record actions of this executor, can be null
     */
    CEExecutor(PoshPlan plan, CompetenceElement ce, VariableContext ctx, Logger log) {
        super(ctx, log);

        name = ce.getName();
        trigger = new SenseListExecutor(ce.getTriggerSenses(), ctx, log);
        maxRetries = ce.getRetries() == null ? -1 : ce.getRetries();
        this.plan = plan;
        this.actionCall = ce.getAction().getActionCall();
    }

    /**
     * FIXME: I should probably make single method and join methods in CEExecutor, APExecutor and DEExecutor
     * @param plan
     * @param actionCall
     * @return
     */
    private StackElement createActionExecutor(PoshPlan plan, Sense.SenseCall actionCall) {
        String actionName = actionCall.getName();

        for (ActionPattern ap : plan.getActionPatterns()) {
            if (actionName.equals(ap.getName())) {
                return new StackElement(ActionPattern.class, actionName, new APExecutor(plan, ap, FireResult.Type.SURFACE,
                        new VariableContext(ctx, actionCall.getParameters(), ap.getParameters()), log));
            }
        }
        for (Competence c : plan.getCompetences()) {
            if (actionName.equals(c.getName())) {
                return new StackElement(Competence.class, actionName, new CExecutor(plan, c,
                        new VariableContext(ctx, actionCall.getParameters(), c.getParameters()), log));
            }
        }
        return new StackElement(TriggeredAction.class, actionName,
                new PrimitiveExecutor(
                    actionCall,
                    FireResult.Type.SURFACE,
                    FireResult.Type.FAILED,
                    new VariableContext(ctx, actionCall.getParameters()),
                    log));
    }

    /**
     * Can this executor be executed? Are all preconditions (triggers and 
     * retries) OK?
     * @param workExecuter
     * @return
     */
    TriggerResult isReady(IWorkExecutor workExecuter) {
        fine("isReady? " + retries + "/" + maxRetries);
        if (maxRetries < 0 || retries < maxRetries) {
            result = trigger.fire(workExecuter, true);
        } else {
            result = new TriggerResult(false);
        }
        return result;
    }

    /**
     * How should this behave:
     *  - if called from above, return new FOLLOW element for the action
     *  - if the action was already finished, return
     * @param workExecuter
     * @return
     */
    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (actionCalled) {
            actionCalled = false;
            return new FireResult(FireResult.Type.SURFACE);
        }

        retries++;
        actionCalled = true;
        return new FireResult(FireResult.Type.FOLLOW, createActionExecutor(plan, actionCall));
    }

    private boolean actionCalled = false;

    /**
     * @return Get name of this CE
     */
    String getName() {
        return name;
    }

    @Override
    public TriggerResult getTriggerResult() {
        return result;
    }
}
