package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;

/**
 * Interface that is used by posh engine to execute primitives.
 * There may be multiple ways to execute primitives, original posh is just
 * calling methods, we may want primitives executed in phases (like INIT, RUN*, FINISH).
 * 
 * @author Honza
 */
public interface IWorkExecutor {
    /**
     * Execute primitive and get the result.
     * @param primitive name of primitive
     * @param ctx variable context for primitive, basically parameteres for primitive
     * @return result of executed primitive
     */
    Object executePrimitive(String primitive, VariableContext ctx);
}
