/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.List;

public class Sense
extends NamedLapElement
implements Comparable<Sense> {
    private SenseCall senseCall;
    private boolean compare = true;
    private Predicate _predicate = Predicate.DEFAULT;
    private Object operand = true;
    public static final String psSenseName = "paSenseName";
    public static final String psPredicateIndex = "paPredicate";
    public static final String psValue = "paValue";
    public static final String psType = "paType";
    public static final DataFlavor dataFlavor = new DataFlavor(Sense.class, "sense");

    public Sense(String senseName) {
        this(new SenseCall(senseName));
    }

    public Sense(SenseCall senseCall) {
        this.senseCall = senseCall;
        this.compare = false;
    }

    public Sense(String senseName, String value, String predicate) {
        this(new SenseCall(senseName), Result.parseValue(value), Predicate.getPredicate(predicate));
    }

    Sense(String senseName, String value, Predicate predicate) {
        this(new SenseCall(senseName), Result.parseValue(value), predicate);
    }

    public Sense(SenseCall senseCall, String operand, Predicate predicate) {
        this(senseCall, Result.parseValue(operand), predicate);
    }

    private Sense(SenseCall senseCall, Object operand, Predicate predicate) {
        assert (predicate != null);
        this.senseCall = senseCall;
        this.compare = true;
        this.operand = operand;
        this._predicate = predicate;
    }

    public String getSenseName() {
        return this.senseCall.getName();
    }

    public SenseCall getSenseCall() {
        return this.senseCall;
    }

    public void setSenseName(String newSenseName) {
        if ((newSenseName = newSenseName.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            String oldSenseName = this.senseCall.getName();
            this.senseCall = new SenseCall(newSenseName, this.senseCall.getParameters());
            this.firePropertyChange(psSenseName, oldSenseName, newSenseName);
        }
    }

    public String getValueString() {
        return this.operand == null ? "null" : this.operand.toString();
    }

    public void setValueString(String newValueString) {
        this.compare = true;
        this.operand = Result.parseValue(newValueString);
        this.firePropertyChange(psValue, null, this.operand == null ? "null" : this.operand.toString());
    }

    public Object getOperand() {
        return this.operand;
    }

    public void setOperand(Object newValue) {
        this.operand = newValue;
        this.firePropertyChange(psValue, this.operand, this.operand);
    }

    public Integer getPredicateIndex() {
        return this._predicate.getId();
    }

    public Predicate getPredicate() {
        return this._predicate;
    }

    public void setPredicate(Predicate newPredicate) {
        this.compare = true;
        this._predicate = newPredicate;
        this.firePropertyChange(psPredicateIndex, null, newPredicate.getId());
    }

    public void setPredicateIndex(Integer newPredicateIndex) {
        if (newPredicateIndex != null) {
            this._predicate = Predicate.values()[newPredicateIndex];
            this.firePropertyChange(psPredicateIndex, null, newPredicateIndex);
        } else {
            this._predicate = Predicate.DEFAULT;
            this.firePropertyChange(psPredicateIndex, null, Predicate.DEFAULT.getId());
        }
    }

    public void changeTo(Sense other) {
        this.compare = other.compare;
        this.setSenseName(other.getSenseName());
        this.setOperand(other.getOperand());
        this.setPredicateIndex(other.getPredicateIndex());
    }

    public String toString() {
        String res = "(" + this.senseCall;
        if (this.compare) {
            res = res + " " + this.operand;
            if (this._predicate != Predicate.DEFAULT) {
                res = res + " " + (Object)((Object)this._predicate);
            }
        }
        return res + ")";
    }

    @Override
    public String getName() {
        return this.senseCall.getName();
    }

    public List<PoshElement> getChildDataNodes() {
        return Collections.emptyList();
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return false;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        throw new RuntimeException("Sense doesn't have children.");
    }

    public String getRepresentation() {
        StringBuilder representation = new StringBuilder(this.getSenseName());
        if (this.compare) {
            representation.append((Object)this._predicate);
            representation.append(this.operand);
        }
        return representation.toString();
    }

    @Override
    public int compareTo(Sense o) {
        return this.getRepresentation().compareTo(o.getRepresentation());
    }

    public static class SenseCall {
        private final String name;
        private final Arguments parameters;

        protected SenseCall(String name) {
            this.name = name;
            this.parameters = new Arguments();
        }

        protected SenseCall(String name, Arguments parameters) {
            this.name = name;
            this.parameters = new Arguments(parameters);
        }

        public String getName() {
            return this.name;
        }

        public Arguments getParameters() {
            return this.parameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            if (!this.parameters.isEmpty()) {
                sb.append('(');
                sb.append(this.parameters.toString());
                sb.append(')');
            }
            return sb.toString();
        }
    }

    public static enum Predicate {
        EQUAL(new String[]{"==", "="}),
        NOT_EQUAL("!="),
        LOWER("<"),
        GREATER(">"),
        LOWER_OR_EQUAL("<="),
        GREATER_OR_EQUAL(">="),
        DEFAULT("==");

        private String[] stringForm = null;

        private Predicate(String form) {
            this.stringForm = new String[]{form};
        }

        private Predicate(String[] form) {
            this.stringForm = form;
        }

        public static Predicate getPredicate(String str) {
            if (str == null) {
                return DEFAULT;
            }
            str = str.trim();
            for (Predicate p : Predicate.values()) {
                for (String form : p.stringForm) {
                    if (!form.equals(str)) continue;
                    return p;
                }
            }
            throw new IllegalArgumentException("String \"" + str + "\" is not a predicate.");
        }

        public int getId() {
            for (int i = 0; i < Predicate.values().length; ++i) {
                if (Predicate.values()[i] != this) continue;
                return i;
            }
            throw new RuntimeException("Predicate \"" + this.toString() + "\" wasn't found in list of predicates.");
        }

        public String toString() {
            return this.stringForm[0];
        }
    }
}

