/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PrimitiveExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

class APExecutor
extends AbstractExecutor
implements ElementExecutor {
    private ActionPattern actionPattern;
    private PoshPlan plan;
    private int index = 0;
    private FireResult.Type result;

    APExecutor(PoshPlan plan, ActionPattern ap, FireResult.Type result, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.result = result;
        this.index = 0;
        this.plan = plan;
        this.actionPattern = ap;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (this.index == this.actionPattern.getTriggeredActions().size()) {
            return new FireResult(this.result);
        }
        TriggeredAction action = this.actionPattern.getTriggeredActions().get(this.index++);
        StackElement stackElement = this.createActionExecutor(this.plan, action.getActionCall());
        return new FireResult(FireResult.Type.FOLLOW, stackElement);
    }

    private StackElement createActionExecutor(PoshPlan plan, Sense.SenseCall actionCall) {
        String actionName = actionCall.getName();
        for (ActionPattern ap : plan.getActionPatterns()) {
            if (!actionName.equals(ap.getName())) continue;
            return new StackElement<APExecutor>(ActionPattern.class, actionName, new APExecutor(plan, ap, FireResult.Type.SURFACE, new VariableContext(this.ctx, actionCall.getParameters(), ap.getParameters()), this.log));
        }
        for (Competence c : plan.getCompetences()) {
            if (!actionName.equals(c.getName())) continue;
            return new StackElement<CExecutor>(Competence.class, actionName, new CExecutor(plan, c, new VariableContext(this.ctx, actionCall.getParameters(), c.getParameters()), this.log));
        }
        return new StackElement<PrimitiveExecutor>(TriggeredAction.class, actionName, new PrimitiveExecutor(actionCall, FireResult.Type.SURFACE, FireResult.Type.FAILED, new VariableContext(this.ctx, actionCall.getParameters()), this.log));
    }

    @Override
    public TriggerResult getTriggerResult() {
        return new TriggerResult(true);
    }
}

