/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PoshElement {
    private PoshElement _parent;
    private final Set<PoshElementListener> elementListeners = new HashSet<PoshElementListener>();
    private final Set<PoshElementListener> elementListenersUm = Collections.unmodifiableSet(this.elementListeners);

    public Set<PoshElementListener> getElementListeners() {
        return this.elementListenersUm;
    }

    public synchronized void addElementListener(PoshElementListener listener) {
        this.elementListeners.add(listener);
    }

    public synchronized void removeElementListener(PoshElementListener listener) {
        this.elementListeners.remove(listener);
    }

    protected synchronized void firePropertyChange(String name, Object o, Object n) {
        PoshElementListener[] listeners;
        for (PoshElementListener listener : listeners = this.elementListenersUm.toArray(new PoshElementListener[0])) {
            listener.propertyChange(new PropertyChangeEvent(this, name, o, n));
        }
    }

    public int getNumberOfChildInstances(Class searchedClass) {
        int numEl = 0;
        for (PoshElement poshElement : this.getChildDataNodes()) {
            if (!poshElement.getClass().equals(searchedClass)) continue;
            ++numEl;
        }
        return numEl;
    }

    public abstract DataFlavor getDataFlavor();

    public abstract List<? extends PoshElement> getChildDataNodes();

    /*
     * WARNING - void declaration
     */
    protected final synchronized void emitChildNode(PoshElement emitedChild) {
        void var5_7;
        PoshElementListener[] listenersArray;
        PoshElementListener[] arr$ = listenersArray = this.elementListenersUm.toArray(new PoshElementListener[0]);
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            PoshElementListener listener = arr$[var5_7];
            listener.nodeChanged(PoshTreeEvent.NEW_CHILD_NODE, emitedChild);
            ++var5_7;
        }
        List<? extends PoshElement> children = emitedChild.getChildDataNodes();
        for (PoshElement poshElement : children) {
            emitedChild.emitChildNode(poshElement);
        }
    }

    protected final synchronized void emitChildMove(PoshElement childNode, int relativeMove) {
        PoshElementListener[] listenersArray;
        for (PoshElementListener listener : listenersArray = this.elementListenersUm.toArray(new PoshElementListener[0])) {
            listener.nodeChanged(PoshTreeEvent.CHILD_NODE_MOVED, childNode);
        }
    }

    protected final synchronized void emitNodeDeleted() {
        PoshElementListener[] listenersArray;
        for (PoshElementListener listener : listenersArray = this.elementListenersUm.toArray(new PoshElementListener[0])) {
            listener.nodeChanged(PoshTreeEvent.NODE_DELETED, this);
        }
    }

    protected void setParent(PoshElement parent) {
        this._parent = parent;
    }

    public PoshElement getParent() {
        return this._parent;
    }

    public final PoshPlan getRootNode() {
        PoshElement cur = this;
        while (cur.getParent() != null) {
            cur = cur.getParent();
        }
        if (cur instanceof PoshPlan) {
            return (PoshPlan)cur;
        }
        return null;
    }

    public abstract void addChildDataNode(PoshElement var1) throws ParseException;

    public abstract boolean moveChild(PoshElement var1, int var2);

    public abstract void neutralizeChild(PoshElement var1);

    protected int getRelativePosition(PoshElement newNode) {
        int dataNodePos = 0;
        int newNodePos = 0;
        int index = 0;
        for (PoshElement poshElement : this._parent.getChildDataNodes()) {
            if (poshElement == this) {
                dataNodePos = index;
            }
            if (poshElement == newNode) {
                newNodePos = index;
            }
            ++index;
        }
        return dataNodePos - newNodePos;
    }

    public final void remove() {
        for (PoshElement poshElement : this.getChildDataNodes()) {
            poshElement.remove();
        }
        this.emitNodeDeleted();
    }

    public final void neutralize() {
        this.getParent().neutralizeChild(this);
    }
}

