/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ElementList;
import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompetenceElement
extends NamedLapElement {
    private String name;
    private ElementList<Sense> triggers;
    private TriggeredAction action;
    private Integer retries;
    private String comment;
    public static final String caName = "caName";
    public static final String caRetries = "caRetries";
    public static final String caComment = "caComment";
    public static final DataFlavor dataFlavor = new DataFlavor(CompetenceElement.class, "competence-atom");

    static CompetenceElement create() {
        return new CompetenceElement("choice", new Sense("succeed"), "doNothing", null);
    }

    static CompetenceElement create(String name) {
        return new CompetenceElement(name, new Sense("succeed"), "doNothing", null);
    }

    public CompetenceElement(String name, ElementList<Sense> triggers, String actionName, Integer retries, String comment) {
        this(name, triggers, new Sense.SenseCall(actionName), retries, comment);
    }

    public CompetenceElement(String name, ElementList<Sense> triggers, Sense.SenseCall actionCall, Integer retries, String comment) {
        if (triggers == null) {
            triggers = new ElementList();
        }
        this.name = name;
        this.triggers = triggers;
        this.action = new TriggeredAction(actionCall);
        this.retries = retries;
        this.comment = comment;
        this.action.setParent(this);
        for (Sense sense : triggers) {
            sense.setParent(this);
        }
    }

    public CompetenceElement(String name, Sense triggers, String actionName, Integer retries) {
        this(name, new ElementList<Sense>(new Sense[]{triggers}), actionName, retries, null);
    }

    public void addTriggerAct(Sense trigger) {
        trigger.setParent(this);
        this.triggers.add(trigger);
        this.emitChildNode(trigger);
    }

    public void addUserTrigger(Sense trigger) {
        if (this.triggers.size() == 1 && ("fail".equals(((Sense)this.triggers.get(0)).getSenseName()) || "succeed".equals(((Sense)this.triggers.get(0)).getSenseName()))) {
            ((Sense)this.triggers.get(0)).changeTo(trigger);
        } else {
            this.addTriggerAct(trigger);
        }
    }

    public void setAction(TriggeredAction newAction) {
        this.action.remove();
        this.action.setParent(null);
        newAction.setParent(this);
        this.action = newAction;
        this.emitChildNode(newAction);
    }

    public TriggeredAction getAction() {
        return this.action;
    }

    public String toString() {
        String ret = this.triggers.size() == 0 ? "(" + this.name + " " + this.action.getName() : "(" + this.name + " (trigger " + this.triggers.toString() + ") " + this.action.getName();
        if (this.retries != null) {
            ret = ret + " " + this.retries.toString();
        }
        if (this.comment != null) {
            ret = ret + " \"" + this.comment + "\"";
        }
        return ret + ")";
    }

    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>(this.triggers);
        children.add((Sense)((Object)this.action));
        return children;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if ((name = name.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            this.name = name;
            this.firePropertyChange(caName, null, name);
        }
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
        this.firePropertyChange(caRetries, null, retries);
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return this.moveNodeInList(this.triggers, child, relativePosition);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (newChild instanceof Sense) {
            this.addTriggerAct((Sense)newChild);
        } else if (newChild instanceof TriggeredAction) {
            this.setAction((TriggeredAction)newChild);
        }
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this.action == childNode) {
            this.setAction(new TriggeredAction("do_nothing"));
        } else if (this.triggers.contains(childNode)) {
            if (this.triggers.size() <= 1) {
                this.addTriggerAct(new Sense("succeed"));
            }
            this.triggers.remove(childNode);
            childNode.remove();
        }
    }

    public List<Sense> getTriggerSenses() {
        return Collections.unmodifiableList(this.triggers);
    }
}

