/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.shady;

import cz.cuni.amis.pogamut.shady.IQuery;
import cz.cuni.amis.pogamut.shady.QueryAnd;
import cz.cuni.amis.pogamut.shady.QueryEq;
import cz.cuni.amis.pogamut.shady.QueryGe;
import cz.cuni.amis.pogamut.shady.QueryGt;
import cz.cuni.amis.pogamut.shady.QueryLe;
import cz.cuni.amis.pogamut.shady.QueryLt;
import cz.cuni.amis.pogamut.shady.QueryNe;
import cz.cuni.amis.pogamut.shady.QueryNot;
import cz.cuni.amis.pogamut.shady.QueryNumber;
import cz.cuni.amis.pogamut.shady.QueryOr;
import cz.cuni.amis.pogamut.sposh.engine.ITestPrimitive;
import cz.cuni.amis.pogamut.sposh.engine.TestWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryTests {
    private IWorkExecutor executor;

    @Before
    public void setUp() {
        this.executor = new TestWorkExecutor(new ITestPrimitive[0]);
    }

    @Test
    public void testQueryNot() {
        System.out.println("query not - execute");
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNot((IQuery)new QueryNumber(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNot((IQuery)new QueryNumber(-1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNot((IQuery)new QueryNumber(42)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNot((IQuery)new QueryNumber(-95)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNot((IQuery)new QueryNumber(-123)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryNot((IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryNot((IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryNot((IQuery)new QueryNumber(0)).execute(this.executor));
    }

    private List<IQuery> createArgs(int ... numbers) {
        LinkedList<IQuery> args = new LinkedList<IQuery>();
        for (int number : numbers) {
            args.add(new QueryNumber(number));
        }
        return args;
    }

    @Test
    public void testQueryAnd() {
        System.out.println("query and - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryAnd(this.createArgs(1, 2, -1, 42)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryAnd(this.createArgs(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryAnd(this.createArgs(-1, -10, -3)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryAnd(this.createArgs(1, 2, 3, 0, 45, 0, 4)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryAnd(this.createArgs(0, 5, 0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryAnd(this.createArgs(99, 0, 5)).execute(this.executor));
    }

    @Test
    public void testQueryOr() {
        System.out.println("query or - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryOr(this.createArgs(1, 2, -1, 100, 666, 42)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryOr(this.createArgs(5)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryOr(this.createArgs(-45, -1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryOr(this.createArgs(0, 5)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryOr(this.createArgs(65, 48, 2, 75, 8, 6, 1, 7, 46, 5, 32, 0, 5)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryOr(this.createArgs(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryOr(this.createArgs(0, 0, 0, 0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryOr(this.createArgs(0, 0, 0, 0, 0, 0, 0)).execute(this.executor));
    }

    @Test
    public void testQueryGt() {
        System.out.println("query gt - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGt((IQuery)new QueryNumber(20), (IQuery)new QueryNumber(10)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGt((IQuery)new QueryNumber(-1000), (IQuery)new QueryNumber(-1001)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGt((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(-1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGt((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGt((IQuery)new QueryNumber(2), (IQuery)new QueryNumber(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGt((IQuery)new QueryNumber(102), (IQuery)new QueryNumber(-101)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGt((IQuery)new QueryNumber(-1001), (IQuery)new QueryNumber(-1000)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGt((IQuery)new QueryNumber(-1), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGt((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGt((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(2)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGt((IQuery)new QueryNumber(-101), (IQuery)new QueryNumber(102)).execute(this.executor));
    }

    @Test
    public void testQueryGe() {
        System.out.println("query ge - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(20), (IQuery)new QueryNumber(10)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(-1000), (IQuery)new QueryNumber(-1001)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(-1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(2), (IQuery)new QueryNumber(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(102), (IQuery)new QueryNumber(-101)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(-10), (IQuery)new QueryNumber(-10)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryGe((IQuery)new QueryNumber(11), (IQuery)new QueryNumber(11)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGe((IQuery)new QueryNumber(-1001), (IQuery)new QueryNumber(-1000)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGe((IQuery)new QueryNumber(-1), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGe((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGe((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(2)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryGe((IQuery)new QueryNumber(-101), (IQuery)new QueryNumber(102)).execute(this.executor));
    }

    @Test
    public void testQueryEq() {
        System.out.println("query eq - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryEq((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryEq((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryEq((IQuery)new QueryNumber(-42), (IQuery)new QueryNumber(-42)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryEq((IQuery)new QueryNumber(4), (IQuery)new QueryNumber(-4)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryEq((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryEq((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(-1)).execute(this.executor));
    }

    @Test
    public void testQueryNe() {
        System.out.println("query ne - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryNe((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(1)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryNe((IQuery)new QueryNumber(-1), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryNe((IQuery)new QueryNumber(65), (IQuery)new QueryNumber(458)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNe((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNe((IQuery)new QueryNumber(11), (IQuery)new QueryNumber(11)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryNe((IQuery)new QueryNumber(-5), (IQuery)new QueryNumber(-5)).execute(this.executor));
    }

    @Test
    public void testQueryLe() {
        System.out.println("query le - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLe((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(12)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLe((IQuery)new QueryNumber(-10), (IQuery)new QueryNumber(5)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLe((IQuery)new QueryNumber(-15), (IQuery)new QueryNumber(-5)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLe((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLe((IQuery)new QueryNumber(-5), (IQuery)new QueryNumber(-5)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryLe((IQuery)new QueryNumber(-12), (IQuery)new QueryNumber(-13)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryLe((IQuery)new QueryNumber(1), (IQuery)new QueryNumber(0)).execute(this.executor));
    }

    @Test
    public void testQueryLt() {
        System.out.println("query lt - execute");
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLt((IQuery)new QueryNumber(-10), (IQuery)new QueryNumber(0)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLt((IQuery)new QueryNumber(0), (IQuery)new QueryNumber(14)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLt((IQuery)new QueryNumber(13), (IQuery)new QueryNumber(14)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)new QueryLt((IQuery)new QueryNumber(-45), (IQuery)new QueryNumber(-4)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryLt((IQuery)new QueryNumber(-4), (IQuery)new QueryNumber(-4)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryLt((IQuery)new QueryNumber(-4), (IQuery)new QueryNumber(-15)).execute(this.executor));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)new QueryLt((IQuery)new QueryNumber(5), (IQuery)new QueryNumber(0)).execute(this.executor));
    }
}

