package cz.cuni.amis.pogamut.sposh.elements;

import java.util.ArrayList;
import java.util.List;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;

/**
 * Goal contains list of Sense. Goal is part of reactive plans that mark when is
 * plan done its job (all senses of goal has to be fulfilled).
 * 
 * @author Honza Havlicek
 */
public final class Goal extends PoshDummyElement {
    // XXX: more TLC only for use in DC
    static Goal createFail() {
        return new Goal(new Sense("fail"));
    }

    static Goal createEmpty() {
        return new Goal(new ElementList<Sense>());
    }
    
	private ElementList<Sense> _sense_list;

	/**
	 * Create a new goal with no senses.
	 */
	public Goal(Sense sense) {
                sense.setParent(this);

                _sense_list = new ElementList<Sense>();
                _sense_list.add(sense);
	}

	/**
	 * Create a new goal with passed senses.
	 *
	 * @param apList list of senses of goal, not null
	 */
	public Goal(ElementList<Sense> sense_list) {
                for (Sense sense : sense_list) {
                    sense.setParent(this);
                }
		_sense_list = sense_list;
        }

	/**
	 * Add another sense to goal.
	 * @param poshAct sense that will be added.
	 */
	public void addSense(Sense sense) {
		sense.setParent(this);
		_sense_list.add(sense);

                emitChildNode(sense);
	}

    /**
     * If the only sense in the goal is either fail or succeed, replace it with
     * passed sense.
     * <p>
     * Otherwise same as {@link Goal.addSense()}.
     */
    public void addUserSense(Sense sense) {
        if (_sense_list.size() == 1 && ("succeed".equals(_sense_list.get(0).getSenseName()) || "fail".equals(_sense_list.get(0).getSenseName()))) {
            _sense_list.get(0).changeTo(sense);
        } else {
            addSense(sense);
        }
    }

	@Override
	public String toString() {
		return "(goal " + _sense_list.toString()+")";
	}

	@Override
	public List<PoshElement> getChildDataNodes() {
		return new ArrayList<PoshElement>(_sense_list);
	}

	@Override
	public boolean moveChild(PoshElement child, int relativePosition) {
		return moveNodeInList(this._sense_list, child, relativePosition);
	}

	public static final DataFlavor dataFlavor = new DataFlavor(Goal.class, "goal"); 
	
	@Override
	public DataFlavor getDataFlavor() {
		return dataFlavor;
	}

	@Override
	public void addChildDataNode(PoshElement newChild) {
		if (newChild instanceof Sense) {
			this.addSense((Sense) newChild);
		} else { 
			throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
		}
	}

	@Override
	public void neutralizeChild(PoshElement childNode) {
		if (this._sense_list.contains(childNode)) {
			if (this._sense_list.size() <= 1) {
				this.addSense(new Sense("fail"));
			}
			this._sense_list.remove(childNode);
			childNode.remove();
		}
	}

        /**
         * Get unmodifiable list of all senses in the goal.
         */
        public synchronized List<Sense> getSenses() {
            return Collections.unmodifiableList(this._sense_list);
        }
}
