package cz.cuni.amis.pogamut.sposh.elements;

import java.util.ArrayList;
import java.util.List;
import java.awt.datatransfer.DataFlavor;

/**
 * Simple class for representation of documentation element in Posh plan.
 * XXX: Obsolete, add it as variable to PoshTreeRoot.
 * @author Honza Havlicek
 */
public class DocString extends PoshDummyElement {

	static List<PoshElement> children = new ArrayList<PoshElement>();

	private String planName;
	private String author;
	private String comment;
	public static final String docName = "docName";
	public static final String docAuthor = "docAuthor";
	public static final String docComment = "docComment";

	public DocString(String planName, String author, String comments) {
		this.planName = planName.replaceAll("\"", "");
		this.author = author.replaceAll("\"", "");
		this.comment = comments.replaceAll("\"", "");
	}

	@Override
	public String toString() {
		return "\t(documentation \"" + getNodePlanName() + "\" \"" + getNodeAuthor() + "\" \"" + getNodeComment() + "\")";
	}

	@Override
	public List<PoshElement> getChildDataNodes() {
		return children;
	}

        /**
	 * Get name of the POSH plan.
	 * @return name of the plan.
	 */
	public String getNodePlanName() {
		return planName;
	}

	/**
	 * Set name of the POSH plan.
	 * @param planName string without "
	 */
	public void setNodePlanName(String planName) {
		if (!planName.contains("\"")) {
			this.planName = planName;
			firePropertyChange(docName, null, planName);
		}
	}

	/**
	 * Get name of the creator of the plan.
	 * @return Name of author of the plan.
	 */
	public String getNodeAuthor() {
		return author;
	}

	/**
	 * Set name(s) of the creator(s) of the POSH plan.
	 * @param author string that doesn't contain "
	 */
	public void setNodeAuthor(String author) {
		author = author.trim();
		if (!author.contains("\"")) {
			this.author = author;
			firePropertyChange(docAuthor, null, author);
		}
	}

	public String getNodeComment() {
		return comment;
	}

	/**
	 * Set commentary about the POSH plan.
	 * 
	 * @param comment string without "
	 */
	public void setNodeComment(String comment) {
		if (comment.contains("\"")) {
			this.comment = comment;
			firePropertyChange(docComment, null, comment);
		}
	}

	@Override
	public boolean moveChild(PoshElement child, int relativePosition) {
		return false;
	}
	public static final DataFlavor dataFlavor = new DataFlavor(DocString.class, "documentation-node");

	@Override
	public DataFlavor getDataFlavor() {
		return dataFlavor;
	}

	@Override
	public void addChildDataNode(PoshElement newChild) {
		throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
	}

	/**
	 * Ignore, documentation nodes doesn't have any children
	 * @param childNode
	 */
	@Override
	public void neutralizeChild(PoshElement childNode) {
	}
}
