/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.DCExecutor;
import cz.cuni.amis.pogamut.sposh.engine.DEExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseResult;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.Set;
import java.util.logging.Logger;

public class PoshEngine {
    protected PoshPlan plan;
    protected ITimer timer;
    protected Logger log;
    private DCExecutor dcExecutor;

    public PoshEngine(PoshPlan plan) {
        this(plan, new SystemClockTimer());
    }

    public PoshEngine(PoshPlan plan, ITimer timer) {
        this(plan, timer, null);
    }

    public PoshEngine(PoshPlan plan, ITimer timer, Logger log) {
        this.plan = plan;
        this.timer = timer;
        this.log = log;
        this.reset();
    }

    public final synchronized void reset() {
        this.dcExecutor = new DCExecutor(this.plan, new VariableContext(), this.timer, this.log);
    }

    public synchronized EvaluationResultInfo evaluatePlan(IWorkExecutor workExecuter) {
        return this.dcExecutor.fire(workExecuter);
    }

    ElementStackTrace getStackForDE(String name) {
        return this.dcExecutor.getStackForDE(name);
    }

    ElementStackTrace getStackForDE(int index) {
        return this.dcExecutor.getStackForDE(index);
    }

    public Logger getLog() {
        return this.log;
    }

    public Set<String> getActions() {
        return this.plan.getActionsNames();
    }

    public Set<String> getSenses() {
        return this.plan.getSensesNames();
    }

    public String getPlan() {
        return this.plan.toString();
    }

    public String getState() {
        StringBuilder sb = new StringBuilder();
        for (DEExecutor de : this.dcExecutor.deExecutors) {
            sb.append("/Root:");
            sb.append(this.plan.getDriveCollection().getName());
            sb.append("/Drive:");
            sb.append(de.getName());
            TriggerResult triggerResult = de.getTriggerResult();
            if (triggerResult != null) {
                for (SenseResult senseResult : triggerResult) {
                    sb.append('[');
                    sb.append(senseResult.name);
                    sb.append(':');
                    sb.append(senseResult.wasSuccessful() ? (char)'1' : '0');
                    sb.append(']');
                }
            }
            sb.append(de.getStackTrace().toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public static class EvaluationResultInfo {
        public EvaluationResult result;
        public FireResult.Type type;

        public EvaluationResultInfo(EvaluationResult result, FireResult.Type type) {
            this.result = result;
            this.type = type;
        }
    }

    public static enum EvaluationResult {
        GOAL_SATISFIED,
        ELEMENT_FIRED,
        NO_ELEMENT_FIRED;

    }
}

