/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import java.lang.reflect.Array;
import java.util.regex.Pattern;

public class Result {
    public static boolean isFalse(Object value) {
        if (value == null) {
            return true;
        }
        if (Result.isBoolean(value)) {
            return !Result.getBoolean(value);
        }
        if (Result.isNumber(value)) {
            return Result.getNumber(value).doubleValue() == 0.0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }

    public static boolean isTrue(Object value) {
        return !Result.isFalse(value);
    }

    public static boolean isNumber(Object value) {
        return value instanceof Number;
    }

    public static Number getNumber(Object value) {
        assert (Result.isNumber(value));
        return (Number)value;
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean getBoolean(Object value) {
        assert (Result.isBoolean(value));
        return (Boolean)value;
    }

    public static Object parseValue(String valueString) {
        assert (valueString != null);
        if ("nil".equalsIgnoreCase(valueString)) {
            return null;
        }
        if (Pattern.compile("([Tt]rue)|([Ff]alse)").matcher(valueString).matches()) {
            return Boolean.parseBoolean(valueString);
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException ex) {
            try {
                return Double.parseDouble(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                return valueString;
            }
        }
    }

    public static double getNumerical(Object value) {
        if (Result.isBoolean(value)) {
            return Result.getBoolean(value) ? 1.0 : 0.0;
        }
        return Result.getNumber(value).doubleValue();
    }

    public static boolean isNumerical(Object value) {
        return Result.isNumber(value) || Result.isBoolean(value);
    }

    public static boolean equal(Object operand1, Object operand2) {
        if (Result.isNumerical(operand1) && Result.isNumerical(operand2)) {
            double op2;
            double op1 = Result.getNumerical(operand1);
            return op1 == (op2 = Result.getNumerical(operand2));
        }
        return operand1 == null ? operand2 == null : operand1.equals(operand2);
    }

    public static int compare(Object operand1, Object operand2) {
        if (Result.isNumerical(operand1) && Result.isNumerical(operand2)) {
            double op1 = Result.getNumerical(operand1);
            double op2 = Result.getNumerical(operand2);
            int sig = (int)Math.signum(op1 - op2);
            return sig;
        }
        if (operand1 == null) {
            if (operand2 == null) {
                return 0;
            }
            throw new IllegalArgumentException("I can't compare " + operand1 + " with " + operand2);
        }
        Comparable op1 = (Comparable)operand1;
        Comparable op2 = (Comparable)operand2;
        return op1.compareTo(op2);
    }

    public static String toLap(Object value) {
        if (value == null) {
            return "nil";
        }
        if (value instanceof Character) {
            return "\"" + value.toString() + "\"";
        }
        if (value instanceof String) {
            return "\"" + value.toString() + "\"";
        }
        return value.toString();
    }
}

