/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DocString;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import java.awt.datatransfer.DataFlavor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class PoshPlan
extends PoshDummyElement {
    private DocString _docstring = null;
    private DriveCollection _driveCollection = null;
    private List<ActionPattern> _actionPatterns = new ArrayList<ActionPattern>();
    private List<Competence> _competences = new ArrayList<Competence>();
    public static final DataFlavor dataFlavor = new DataFlavor(PoshPlan.class, "posh_tree_root");

    public Set<String> getActionsNames() {
        String actionName;
        HashSet<String> result = new HashSet<String>();
        for (ActionPattern ap : this._actionPatterns) {
            for (TriggeredAction action : ap.getTriggeredActions()) {
                actionName = action.getName();
                if (this.isAP(actionName) || this.isC(actionName)) continue;
                result.add(actionName);
            }
        }
        for (Competence c : this._competences) {
            for (CompetenceElement ce : c.getChildDataNodes()) {
                actionName = ce.getAction().getName();
                if (this.isAP(actionName) || this.isC(actionName)) continue;
                result.add(actionName);
            }
        }
        for (DriveElement de : this._driveCollection.getDrives()) {
            String actionName2 = de.getTriggeredAction().getName();
            if (this.isAP(actionName2) || this.isC(actionName2)) continue;
            result.add(actionName2);
        }
        return result;
    }

    public Set<String> getSensesNames() {
        HashSet<String> result = new HashSet<String>();
        Goal dcGoal = this._driveCollection.getGoal();
        if (dcGoal != null) {
            for (Sense sense : dcGoal.getSenses()) {
                result.add(sense.getSenseName());
            }
        }
        for (DriveElement de : this._driveCollection.getDrives()) {
            for (Sense sense : de.getTriggers().getSenses()) {
                result.add(sense.getSenseName());
            }
        }
        for (Competence c : this._competences) {
            for (CompetenceElement ce : c.getChildDataNodes()) {
                for (Sense sense : ce.getTriggerSenses()) {
                    result.add(sense.getSenseName());
                }
            }
        }
        return result;
    }

    public boolean isC(String name) {
        return this.getC(name) != null;
    }

    public Competence getC(String name) {
        for (Competence c : this.getCompetences()) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public boolean isAP(String name) {
        return this.getAP(name) != null;
    }

    public ActionPattern getAP(String name) {
        for (ActionPattern ap : this.getActionPatterns()) {
            if (!ap.getName().equals(name)) continue;
            return ap;
        }
        return null;
    }

    public boolean isUniqueAPorComp(String id) {
        for (ActionPattern actionPattern : this._actionPatterns) {
            if (!actionPattern.getName().equals(id)) continue;
            return false;
        }
        for (Competence competence : this._competences) {
            if (!competence.getName().equals(id)) continue;
            return false;
        }
        return true;
    }

    private void refreshActions() {
        LinkedList<TriggeredAction> actions = new LinkedList<TriggeredAction>();
        List<ActionPattern> aps = this.getActionPatterns();
        List<Competence> competences = this.getCompetences();
        for (ActionPattern ap : aps) {
            for (TriggeredAction action : ap.getTriggeredActions()) {
                actions.add(action);
            }
        }
        for (Competence competence : competences) {
            for (CompetenceElement ce : competence.getChildDataNodes()) {
                actions.add(ce.getAction());
            }
        }
        if (this.getDriveCollection() != null) {
            for (DriveElement de : this.getDriveCollection().getDrives()) {
                actions.add(de.getTriggeredAction());
            }
        }
        for (TriggeredAction action : actions) {
            action.setActionName(action.getName());
        }
    }

    public void setDocString(DocString docstring) {
        docstring.setParent(this);
        if (this._docstring != null) {
            this._docstring.remove();
        }
        this._docstring = docstring;
        this.emitChildNode(this._docstring);
    }

    public void addCompetence(Competence competence) throws DuplicateNameException, CycleException {
        if (!this.isUniqueAPorComp(competence.getName())) {
            throw new DuplicateNameException("Competence  '" + competence.getName() + "' has duplicate name in POSH plan.");
        }
        competence.setParent(this);
        this._competences.add(competence);
        if (this.isCycled()) {
            this._competences.remove(competence);
            throw new CycleException("Competence " + competence.getName() + " is causing cycle.");
        }
        this.emitChildNode(competence);
        this.refreshActions();
    }

    public List<Competence> getCompetences() {
        return Collections.unmodifiableList(this._competences);
    }

    public void addActionPattern(ActionPattern actionPattern) throws DuplicateNameException, CycleException {
        if (!this.isUniqueAPorComp(actionPattern.getName())) {
            throw new DuplicateNameException("Action pattern '" + actionPattern.getName() + "' has duplicate name in POSH plan.");
        }
        actionPattern.setParent(this);
        this._actionPatterns.add(actionPattern);
        if (this.isCycled()) {
            this._actionPatterns.remove(actionPattern);
            throw new CycleException("Action pattern '" + actionPattern.getName() + "' is causing cycle.");
        }
        this.emitChildNode(actionPattern);
        this.refreshActions();
    }

    public List<ActionPattern> getActionPatterns() {
        return Collections.unmodifiableList(this._actionPatterns);
    }

    protected void setDriveCollection(DriveCollection dc) {
        dc.setParent(this);
        if (this._driveCollection != null) {
            this._driveCollection.remove();
        }
        this._driveCollection = dc;
        this.emitChildNode(this._driveCollection);
    }

    public DriveCollection getDriveCollection() {
        return this._driveCollection;
    }

    public boolean isCycled() {
        for (ActionPattern apNode : this._actionPatterns) {
            if (!this.findCycle(apNode, new HashSet<String>())) continue;
            return true;
        }
        for (Competence compNode : this._competences) {
            if (!this.findCycle(compNode, new HashSet<String>())) continue;
            return true;
        }
        return false;
    }

    private boolean findCycle(ActionPattern apNode, Set<String> set) {
        if (set.contains(apNode.getName())) {
            return true;
        }
        set.add(apNode.getName());
        for (TriggeredAction action : apNode._actions) {
            ActionPattern actionAP = this.getAP(action.getName());
            if (actionAP != null && this.findCycle(actionAP, set)) {
                return true;
            }
            Competence actionComp = this.getC(action.getName());
            if (actionComp == null || !this.findCycle(actionComp, set)) continue;
            return true;
        }
        set.remove(apNode.getName());
        return false;
    }

    private boolean findCycle(Competence compNode, Set<String> set) {
        if (set.contains(compNode.getName())) {
            return true;
        }
        set.add(compNode.getName());
        for (CompetenceElement cAtom : compNode.getChildDataNodes()) {
            TriggeredAction action = cAtom.getAction();
            ActionPattern actionAP = this.getAP(action.getName());
            if (actionAP != null && this.findCycle(actionAP, set)) {
                return true;
            }
            Competence actionComp = this.getC(action.getName());
            if (actionComp == null || !this.findCycle(actionComp, set)) continue;
            return true;
        }
        set.remove(compNode.getName());
        return false;
    }

    protected List<String> getAPorCompActions(String ident) {
        ActionPattern ap = this.getAP(ident);
        if (ap != null) {
            LinkedList<String> actionList = new LinkedList<String>();
            for (TriggeredAction a : ap._actions) {
                actionList.add(a.getName());
            }
            return actionList;
        }
        Competence cn = this.getC(ident);
        if (cn != null) {
            LinkedList<String> actionList = new LinkedList<String>();
            for (CompetenceElement ca : cn.getChildDataNodes()) {
                if (ca.getAction() == null) continue;
                actionList.add(ca.getAction().getName());
            }
            return actionList;
        }
        return new LinkedList<String>();
    }

    public String toString() {
        String ret = "(";
        if (this._docstring != null) {
            ret = ret + "\n" + this._docstring.toString();
        }
        for (Competence competence : this._competences) {
            ret = ret + "\n" + competence.toString();
        }
        for (ActionPattern actionPattern : this._actionPatterns) {
            ret = ret + "\n" + actionPattern.toString();
        }
        if (this._driveCollection != null) {
            ret = ret + "\n" + this._driveCollection.toString();
        }
        ret = ret + "\n)";
        return ret;
    }

    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>();
        if (this._docstring != null) {
            children.add(this._docstring);
        }
        for (Competence competence : this._competences) {
            children.add(competence);
        }
        for (ActionPattern actionPattern : this._actionPatterns) {
            children.add(actionPattern);
        }
        if (this._driveCollection != null) {
            children.add(this._driveCollection);
        }
        return children;
    }

    public synchronized void removeListenersFromTree(PoshElementListener listener) {
        this.getRootNode().removeListenersFromTree(this, listener);
    }

    protected synchronized void removeListenersFromTree(PoshElement node, PoshElementListener listener) {
        node.removeElementListener(listener);
        for (PoshElement poshElement : node.getChildDataNodes()) {
            this.removeListenersFromTree(poshElement, listener);
        }
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        if (this._competences.contains(child)) {
            return this.moveNodeInList(this._competences, child, relativePosition);
        }
        if (this._actionPatterns.contains(child)) {
            return this.moveNodeInList(this._actionPatterns, child, relativePosition);
        }
        return false;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) throws ParseException {
        if (newChild instanceof DocString) {
            this.setDocString((DocString)newChild);
        } else if (newChild instanceof Competence) {
            this.addCompetence((Competence)newChild);
        } else if (newChild instanceof ActionPattern) {
            this.addActionPattern((ActionPattern)newChild);
        } else if (newChild instanceof DriveCollection) {
            this.setDriveCollection((DriveCollection)newChild);
        } else {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this._docstring == childNode) {
            this._docstring = null;
            childNode.remove();
        } else if (this._competences.contains(childNode)) {
            this._competences.remove(childNode);
            childNode.remove();
        } else if (this._actionPatterns.contains(childNode)) {
            this._actionPatterns.remove(childNode);
            childNode.remove();
        } else if (this._driveCollection == childNode) {
            this._driveCollection = null;
            childNode.remove();
        }
    }

    public void emitTree() {
        for (PoshElement pe : this.getChildDataNodes()) {
            this.emitChildNode(pe);
        }
    }

    public void synchronizePlan(InputStream stream) throws ParseException, CycleException {
        Competence[] cs;
        ActionPattern[] aps;
        PoshParser parser = new PoshParser(stream);
        PoshPlan parsedPlan = parser.parsePlan();
        if (this._docstring != null) {
            this.neutralizeChild(this._docstring);
        }
        if (this._driveCollection != null) {
            this.neutralizeChild(this._driveCollection);
        }
        for (ActionPattern ap : aps = this.getActionPatterns().toArray(new ActionPattern[0])) {
            this.neutralizeChild(ap);
        }
        for (Competence c : cs = this.getCompetences().toArray(new Competence[0])) {
            this.neutralizeChild(c);
        }
        this.setDocString(parsedPlan._docstring);
        this.setDriveCollection(parsedPlan._driveCollection);
        for (ActionPattern ap : parsedPlan.getActionPatterns()) {
            this.addActionPattern(ap);
        }
        for (Competence c : parsedPlan.getCompetences()) {
            this.addCompetence(c);
        }
    }
}

