/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompetenceTest {
    List<CompetenceElement> elements;
    List<DummyListener> listeners;
    int num = 10;
    int reps = 100;

    @Test
    public void testAddElement() throws DuplicateNameException {
        System.out.println("addElement");
        Competence instance = new Competence("test", new FormalParameters(), Collections.emptyList());
        DummyListener listener = new DummyListener();
        instance.addElementListener((PoshElementListener)listener);
        CompetenceElement element = CompetenceElement.create();
        instance.addElement(element);
        Assert.assertTrue((listener.lastChild == element && listener.lastEvent == PoshTreeEvent.NEW_CHILD_NODE ? 1 : 0) != 0);
    }

    @Test(expected=DuplicateNameException.class)
    public void testAddElementDuplicateName() throws DuplicateNameException {
        System.out.println("addElement - duplicate name");
        Competence instance = new Competence("test", new FormalParameters(), Collections.emptyList());
        instance.addElement(CompetenceElement.create());
        instance.addElement(CompetenceElement.create());
    }

    @Test(expected=AssertionError.class)
    public void testAddElementLeakingParent() throws DuplicateNameException {
        System.out.println("addElement - leaking parent");
        Competence instance = new Competence("test", new FormalParameters(), Collections.emptyList());
        instance.addElement(CompetenceElement.create((String)"test-element"));
        Competence leak = new Competence("leak", new FormalParameters(), Collections.emptyList());
        CompetenceElement leakElement = CompetenceElement.create((String)"leak-element");
        leak.addElement(leakElement);
        instance.addElement(leakElement);
    }

    @Test
    public void testSetName() throws Exception {
        System.out.println("setName");
        String orgName = "test-set-name";
        String newName = "new-name";
        Competence instance = new Competence(orgName, new FormalParameters(), Collections.emptyList());
        DummyListener listener = new DummyListener();
        instance.addElementListener((PoshElementListener)listener);
        instance.setName(newName);
        PropertyChangeEvent evt = listener.lastPropertyChange;
        Assert.assertTrue((evt.getPropertyName().equals("cnName") && evt.getOldValue().equals(orgName) && evt.getNewValue().equals(newName) ? 1 : 0) != 0);
        Assert.assertEquals((Object)instance.getName(), (Object)newName);
    }

    @Test(expected=InvalidNameException.class)
    public void testSetNameInvalidName() throws Exception {
        System.out.println("setName - invalid name");
        String orgName = "test-set-name";
        String newName = "new name";
        Competence instance = new Competence(orgName, new FormalParameters(), Collections.emptyList());
        DummyListener listener = new DummyListener();
        instance.addElementListener((PoshElementListener)listener);
        try {
            instance.setName(newName);
        }
        catch (InvalidNameException ex) {
            Assert.assertNull((Object)listener.lastPropertyChange);
            Assert.assertEquals((Object)instance.getName(), (Object)orgName);
            throw ex;
        }
        Assert.fail((String)"Name shouldn't be valid");
    }

    @Before
    public void setUp() {
        this.elements = new ArrayList<CompetenceElement>();
        this.listeners = new ArrayList<DummyListener>();
        for (int i = 0; i < this.num; ++i) {
            CompetenceElement element = new CompetenceElement("e" + i, new Sense("t" + i), "a" + i, null);
            DummyListener listener = new DummyListener();
            this.listeners.add(listener);
            element.addElementListener((PoshElementListener)listener);
            this.elements.add(element);
        }
    }

    @Test
    public void testNeutralizeChild() {
        System.out.println("neutralizeChild");
        Competence instance = new Competence("testC", new FormalParameters(), this.elements);
        for (int i = 0; i < this.num; ++i) {
            CompetenceElement element = this.elements.get(i);
            Assert.assertTrue((instance.getChildDataNodes().size() == this.num - i ? 1 : 0) != 0);
            Assert.assertTrue((boolean)instance.getChildDataNodes().contains(element));
            instance.neutralizeChild((PoshElement)element);
            Assert.assertFalse((boolean)instance.getChildDataNodes().contains(element));
            Assert.assertFalse((boolean)instance.getChildDataNodes().contains(element));
            Assert.assertTrue((this.listeners.get((int)i).lastEvent == PoshTreeEvent.NODE_DELETED && this.listeners.get((int)i).lastChild == this.elements.get(i) ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)instance.getChildDataNodes().size(), (long)1L);
    }

    public static class DummyListener
    implements PoshElementListener {
        public PoshTreeEvent lastEvent;
        public PoshElement lastChild;
        public PropertyChangeEvent lastPropertyChange;

        public void nodeChanged(PoshTreeEvent event, PoshElement child) {
            this.lastEvent = event;
            this.lastChild = child;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.lastPropertyChange = evt;
        }
    }
}

