package cz.cuni.amis.pogamut.sposh.engine;

import java.util.logging.Logger;

/**
 * Predecesor of all executors, basically provides only logging infrastructure.
 * @author Honza
 */
class AbstractExecutor {
    protected VariableContext ctx;
    protected final Logger log;

    protected AbstractExecutor(VariableContext ctx, Logger log) {
        this.ctx = ctx;
        this.log = log;
    }

    public void fine(String msg) {
        if (log != null)
            log.fine(msg);
    }

    public void info(String msg) {
        if (log != null)
            log.info(msg);
    }
    
    public void warning(String msg) {
        if (log != null)
            log.warning(msg);
    }

    /**
     * Get variable context of this executor.
     * TODO: should this be public?
     */
    public VariableContext getVariableContext() {
        return ctx;
    }
}
