/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PoshParserTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    private String loadPlan(String relativeResourcePath) throws IOException {
        String resourcePath = this.getClass().getPackage().getName().replace('.', '/') + '/' + relativeResourcePath;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            Assert.fail((String)("Unable to open resource \"" + resourcePath + "\""));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        reader.close();
        return sb.toString();
    }

    private void testPoshPlan(String testName, String relativeResourcePath) throws IOException, ParseException {
        System.out.println("Test: " + testName);
        String plan = this.loadPlan(relativeResourcePath);
        PoshParser parser = new PoshParser((Reader)new StringReader(plan));
        parser.parsePlan();
    }

    @Test
    public void testAttackBot() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/joanna/attackbot.lap");
    }

    @Test
    public void testEducateMeMonk() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/joanna/educate-me+monk.lap");
    }

    @Test
    public void testPoshBotFollow() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/joanna/poshbotfollow.lap");
    }

    @Test
    public void testSheepDog() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/joanna/sheep-dog.lap");
    }

    @Test
    public void testStayGroom() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/joanna/stay-groom.lap");
    }

    @Test
    public void testCVarsPresnet() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/CompVarTest.lap");
    }

    @Test
    public void testCVarsNotPresnet() throws Exception {
        try {
            this.testPoshPlan(this.getMethodName(), "testplans/vars/CompVarFail.lap");
        }
        catch (ParseException ex) {
            if (ex.getMessage().contains("<VARIABLE>")) {
                return;
            }
            return;
        }
        Assert.fail((String)"Should throw exception, no parameters");
    }

    @Test
    public void testCVarsMissingDefault() throws Exception {
        try {
            this.testPoshPlan(this.getMethodName(), "testplans/vars/CompVarMissingDefault.lap");
        }
        catch (ParseException ex) {
            if (ex.getMessage().contains("\"=\"")) {
                return;
            }
            return;
        }
        Assert.fail((String)"Should throw exception, no default value for parameter");
    }

    @Test
    public void testAPVarsMissingParameters() throws Exception {
        try {
            this.testPoshPlan(this.getMethodName(), "testplans/vars/APVarsMissingParameters.lap");
        }
        catch (ParseException ex) {
            if (ex.getMessage().contains("\"murder\"")) {
                return;
            }
            return;
        }
        Assert.fail((String)"Should throw exception, no default value for parameter");
    }

    @Test
    public void testAPVarsParameters() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/APVarsParameters.lap");
    }

    @Test
    public void testSenseVarsInComp() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/SenseVarsInComp.lap");
    }

    @Test
    public void testSensesVarsInCompContextFail() throws Exception {
        block2: {
            try {
                this.testPoshPlan(this.getMethodName(), "testplans/vars/SensesVarsInCompContextFail.lap");
            }
            catch (ParseException ex) {
                if (!ex.getMessage().contains("$killbot")) break block2;
                return;
            }
        }
        Assert.fail((String)"Should throw exception, variable $killbot in sense call not defined");
    }

    @Test
    public void testAPActionVar() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/APActionVars.lap");
    }

    @Test
    public void testAPActionVarsContextFail() throws Exception {
        block2: {
            try {
                this.testPoshPlan(this.getMethodName(), "testplans/vars/APActionVarsContextFail.lap");
            }
            catch (ParseException ex) {
                if (!ex.getMessage().contains("$where")) break block2;
                return;
            }
        }
        Assert.fail((String)"Should throw exception, variable $where not defined in AP context.");
    }

    @Test
    public void testCompDuplicateVars() throws Exception {
        block2: {
            try {
                this.testPoshPlan(this.getMethodName(), "testplans/vars/CompDuplicateVars.lap");
            }
            catch (ParseException ex) {
                if (!ex.getMessage().contains("$duplicateVariable")) break block2;
                return;
            }
        }
        Assert.fail((String)"Should throw exception, competence has declared two $duplicateVariable variables.");
    }

    @Test
    public void testCallC() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/CallC.lap");
    }

    @Test
    public void testCallPrimitiveFromC() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/CallPrimitiveFromC.lap");
    }

    @Test
    public void testCallCFromDC() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/CallCFromDC.lap");
    }

    @Test
    public void testCallPrimitiveFromDC() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/CallPrimitiveFromDC.lap");
    }

    @Test
    public void testSenseTriggerVars() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/SenseTriggerVars.lap");
    }

    @Test
    public void testMissingVars() throws Exception {
        block2: {
            try {
                this.testPoshPlan(this.getMethodName(), "testplans/vars/MissingVars.lap");
            }
            catch (ParseException ex) {
                if (!(ex.getMessage().contains("$var1") & ex.getMessage().contains("Encountered"))) break block2;
                return;
            }
        }
        Assert.fail((String)"Should throw exception, missing \"vars\" keyword.");
    }

    @Test
    public void testActionNamedVariable() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/ActionNamedVariable.lap");
    }

    @Test
    public void testNamedActionsFail() throws Exception {
        block2: {
            try {
                this.testPoshPlan(this.getMethodName(), "testplans/vars/NamedActionsFail.lap");
            }
            catch (ParseException ex) {
                if (!(ex.getMessage().contains("unnamed") & ex.getMessage().contains("parameter") & ex.getMessage().contains("named"))) break block2;
                return;
            }
        }
        Assert.fail((String)"Should throw exception, unnamed parameter after named parameter.");
    }

    @Test
    public void testNamedParameterDuplicate() throws Exception {
        block2: {
            try {
                this.testPoshPlan(this.getMethodName(), "testplans/vars/NamedParameterDuplicate.lap");
            }
            catch (ParseException ex) {
                if (!(ex.getMessage().contains("\"$variable\"") & ex.getMessage().contains("already") & ex.getMessage().contains("defined"))) break block2;
                return;
            }
        }
        Assert.fail((String)"Should throw exception, two named parameters were defined.");
    }

    @Test
    public void testNamedCallTest() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/NamedCallTest.lap");
    }

    @Test
    public void testTestStringVariable() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/vars/TestStringVariable.lap");
    }

    @Test
    public void testVarStringFail() throws Exception {
        block2: {
            try {
                this.testPoshPlan(this.getMethodName(), "testplans/vars/VarStringFail.lap");
            }
            catch (ParseException ex) {
                if (!ex.getMessage().contains("Encountered") || !ex.getMessage().contains("\"\\\"\"")) break block2;
                return;
            }
        }
    }

    @Test
    public void testNames() throws Exception {
        this.testPoshPlan(this.getMethodName(), "testplans/001Names.lap");
    }
}

