/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.shady;

import cz.cuni.amis.pogamut.shady.ArgChar;
import cz.cuni.amis.pogamut.shady.ArgFloat;
import cz.cuni.amis.pogamut.shady.ArgInt;
import cz.cuni.amis.pogamut.shady.ArgString;
import cz.cuni.amis.pogamut.shady.IArgument;
import cz.cuni.amis.pogamut.shady.IQuery;
import cz.cuni.amis.pogamut.shady.NodeCall;
import cz.cuni.amis.pogamut.shady.NodeElement;
import cz.cuni.amis.pogamut.shady.QueryCall;
import cz.cuni.amis.pogamut.shady.QueryFloat;
import cz.cuni.amis.pogamut.shady.QueryInt;
import cz.cuni.amis.pogamut.shady.ShadyParser;
import cz.cuni.amis.pogamut.sposh.engine.ITestPrimitive;
import cz.cuni.amis.pogamut.sposh.engine.TestWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ShadyParserTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private void testInfo(String testName) {
        System.out.println(testName);
    }

    @Test
    public void testName() throws Exception {
        String[] okTests;
        this.testInfo("name");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (String test : okTests = new String[]{"fix", "ShadyParser", "cz.cuni.pogamut.shady.ShadyParser", "$love.$$.hate12and_more"}) {
            System.out.println(" - " + test);
            parser.ReInit((Reader)new StringReader(test));
            Assert.assertEquals((Object)parser.name(), (Object)test);
        }
    }

    @Test
    public void testArg() throws Exception {
        Pair[] okTests;
        this.testInfo("arg");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (Pair test : okTests = new Pair[]{new Pair("123", new ArgInt(123)), new Pair("0", new ArgInt(0)), new Pair("-957", new ArgInt(-957)), new Pair("\"Hello World!\"", new ArgString("Hello World!")), new Pair("'a'", new ArgChar('a')), new Pair("'g'", new ArgChar('g')), new Pair("1.2345678900", new ArgFloat(1.23456789)), new Pair(".1230001", new ArgFloat(0.1230001)), new Pair("-42.78", new ArgFloat(-42.78)), new Pair("'g'", new ArgChar('g')), new Pair("'g'", new ArgChar('g')), new Pair("\"Hello\\nWorld\"", new ArgString("Hello\nWorld")), new Pair("'\\r'", new ArgChar('\r')), new Pair("'\\n'", new ArgChar('\n'))}) {
            System.out.println(" - " + test.input);
            parser.ReInit((Reader)new StringReader(test.input));
            Assert.assertEquals((Object)parser.arg(), (Object)test.result);
        }
    }

    @Test
    public void testArgChar() throws Exception {
        Pair[] okTests;
        this.testInfo("argString");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (Pair test : okTests = new Pair[]{new Pair("'a'", new ArgChar('a')), new Pair("'Z'", new ArgChar('Z')), new Pair("'\"'", new ArgChar('\"')), new Pair("'\\\"'", new ArgChar('\"')), new Pair("'\\0'", new ArgChar('\u0000')), new Pair("'\\00'", new ArgChar('\u0000')), new Pair("'\\000'", new ArgChar('\u0000')), new Pair("'\\7'", new ArgChar('\u0007')), new Pair("'\\77'", new ArgChar('?')), new Pair("'\\377'", new ArgChar('\u00ff')), new Pair("'\\5'", new ArgChar('\u0005')), new Pair("'\\42'", new ArgChar('\"')), new Pair("'\\123'", new ArgChar('S')), new Pair("'\\b'", new ArgChar('\b')), new Pair("'\\t'", new ArgChar('\t')), new Pair("'\\n'", new ArgChar('\n')), new Pair("'\\f'", new ArgChar('\f')), new Pair("'\\r'", new ArgChar('\r')), new Pair("'\\''", new ArgChar('\'')), new Pair("'\\\"'", new ArgChar('\"')), new Pair("'\\\\'", new ArgChar('\\')), new Pair("'\u4eca'", new ArgChar('\u4eca')), new Pair("'\\u4eca'", new ArgChar('\u4eca')), new Pair("'\\uuuuuu4eca'", new ArgChar('\u4eca')), new Pair("' '", new ArgChar(' '))}) {
            System.out.println(" - " + test.input);
            parser.ReInit((Reader)new StringReader(test.input));
            Assert.assertEquals((Object)parser.arg(), (Object)test.result);
        }
    }

    @Test
    public void testArgString() throws Exception {
        Pair[] okTests;
        this.testInfo("argString");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (Pair test : okTests = new Pair[]{new Pair("\"\"", new ArgString("")), new Pair("\"Hello\\nWorld\"", new ArgString("Hello\nWorld")), new Pair("\"\\0\"", new ArgString("\u0000")), new Pair("\"\\127\"", new ArgString("W")), new Pair("\"\\0\\11\\01\\00\\000\\001\\111\\377\\7\\2\\12\\32\\77\\255\"", new ArgString("\u0000\t\u0001\u0000\u0000\u0001I\u00ff\u0007\u0002\n\u001a?\u00ad")), new Pair("\"'\"", new ArgString("'")), new Pair("\"\\b\\t\\n\\f\\r\\'\\\"\\\\\"", new ArgString("\b\t\n\f\r'\"\\")), new Pair("\"\\u306A\\u306b \\u30673059 \\u304B?\"", new ArgString("\u306a\u306b \u30673059 \u304b?")), new Pair("\"  \u4eca  A\u4eca\"", new ArgString("  \u4eca  A\u4eca")), new Pair("\"\\n\"", new ArgString("\n"))}) {
            System.out.println(" - " + test.input);
            parser.ReInit((Reader)new StringReader(test.input));
            Assert.assertEquals((Object)parser.arg(), (Object)test.result);
        }
    }

    @Test
    public void testArgs() throws Exception {
        Pair[] okTests;
        this.testInfo("args");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (Pair test : okTests = new Pair[]{new Pair("123", new ArgInt(123))}) {
            System.out.println(" - " + test.input);
            parser.ReInit((Reader)new StringReader(test.input));
            Assert.assertEquals((Object)parser.arg(), (Object)test.result);
        }
    }

    @Test
    public void testCall() throws Exception {
        this.testInfo("call");
        String input = "(test.fix 1 \"Hello world\" -.14 'z')";
        System.out.println(" - " + input);
        ShadyParser parser = new ShadyParser((Reader)new StringReader(input));
        NodeCall call = parser.call();
        Assert.assertEquals((Object)call.getName(), (Object)"test.fix");
        Assert.assertEquals(call.getArgs().get(0), (Object)new ArgInt(1));
        Assert.assertEquals(call.getArgs().get(1), (Object)new ArgString("Hello world"));
        Assert.assertEquals(call.getArgs().get(2), (Object)new ArgFloat(-0.14));
        Assert.assertEquals(call.getArgs().get(3), (Object)new ArgChar('z'));
    }

    private void testQueryCall(String input, String name, IArgument ... args) throws Exception {
        System.out.println(" - " + input);
        ShadyParser parser = new ShadyParser((Reader)new StringReader(input));
        QueryCall call = parser.queryCall();
        Assert.assertEquals((Object)call.getName(), (Object)name);
        for (int argIdx = 0; argIdx < args.length; ++argIdx) {
            Assert.assertEquals(call.getArgs().get(argIdx), (Object)args[argIdx]);
        }
    }

    @Test
    public void testQueryCall() throws Exception {
        this.testInfo("queryCall");
        this.testQueryCall("call9.one-one -1 \"Nya \"    )", "call9.one-one", new IArgument[]{new ArgInt(-1), new ArgString("Nya ")});
        this.testQueryCall("runRabbitRun)", "runRabbitRun", new IArgument[0]);
    }

    private void testValue(String input, IQuery query) throws Exception {
        System.out.println(" - " + input);
        ShadyParser parser = new ShadyParser((Reader)new StringReader(input));
        IQuery value = parser.value();
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[0]);
        Assert.assertEquals((Object)value.execute((IWorkExecutor)executor), (Object)query.execute((IWorkExecutor)executor));
    }

    @Test
    public void testValue() throws Exception {
        String[] okTriggers;
        this.testInfo("value");
        this.testValue("123", (IQuery)new QueryInt(123));
        this.testValue("-982", (IQuery)new QueryInt(-982));
        this.testValue("0", (IQuery)new QueryInt(0));
        this.testValue("1", (IQuery)new QueryInt(1));
        this.testValue("-.5", (IQuery)new QueryFloat(-0.5));
        this.testValue("0.99", (IQuery)new QueryFloat(0.99));
        this.testValue("62.15", (IQuery)new QueryFloat(62.15));
        this.testValue("-.5", (IQuery)new QueryFloat(-0.5));
        this.testValue("0.99", (IQuery)new QueryFloat(0.99));
        this.testValue("62.15", (IQuery)new QueryFloat(62.15));
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (String triggers : okTriggers = new String[]{"(health \"Player Jakub\")", "(adrenaline)", "(love.to.ru12 1 'a')", "(call911)"}) {
            System.out.println(" - " + triggers);
            parser.ReInit((Reader)new StringReader(triggers));
            IQuery value = parser.value();
        }
    }

    @Test
    public void testTrigger() throws Exception {
        String[] okTriggers;
        this.testInfo("trigger");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (String triggerString : okTriggers = new String[]{"(not (and 1 0 2 4))", "(not 1)", "(not (<= (health) 10))", "1", "-0.123", "(>= (health) 90)", "(= 90.0 90)", "(adrenaline \"Player Honza\")", "(or (> (health \"Player Honza\") 90) (> (adrenaline \"Player Honza\") 120))"}) {
            System.out.println(" - " + triggerString);
            parser.ReInit((Reader)new StringReader(triggerString));
            IQuery trigger = parser.trigger();
        }
    }

    @Test
    public void testElement() throws Exception {
        String[] okTriggers;
        this.testInfo("element");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(""));
        for (String elementString : okTriggers = new String[]{"(10 1 (run-home))", "((how-scared \"Noise\") (and (can-run) (has-energy)) (hide-in-burrlow))", "(10 (food-in-proximity 10) (animate \"Rabbit.Sniff.rtm\"))"}) {
            System.out.println(" - " + elementString);
            parser.ReInit((Reader)new StringReader(elementString));
            NodeElement element = parser.element();
        }
    }

    private String loadPlan(String relativeResourcePath) throws IOException {
        String resourcePath = this.getClass().getPackage().getName().replace('.', '/') + '/' + relativeResourcePath;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            Assert.fail((String)("Unable to open resource \"" + resourcePath + "\""));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        reader.close();
        return sb.toString();
    }

    @Test
    public void testTree() throws Exception {
        this.testInfo("element");
        String plan = this.loadPlan("testplans/tree.sde");
        ShadyParser parser = new ShadyParser((Reader)new StringReader(plan));
        parser.plan();
        System.out.println(plan);
    }

    private static class Pair {
        public String input;
        public Object result;

        public Pair(String input, Object result) {
            this.input = input;
            this.result = result;
        }
    }
}

