/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.UnexpectedElementException;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Competence
extends NamedLapElement
implements Comparable<Competence> {
    private String name;
    private FormalParameters params = new FormalParameters();
    private final List<CompetenceElement> elements = new LinkedList<CompetenceElement>();
    private final List<CompetenceElement> elementsUm = Collections.unmodifiableList(this.elements);
    public static final String cnName = "cnName";
    public static final DataFlavor dataFlavor = new DataFlavor(Competence.class, "competence-node");

    public Competence(String name, FormalParameters params, List<CompetenceElement> elements) {
        this.name = name;
        this.params = new FormalParameters(params);
        try {
            for (CompetenceElement element : elements) {
                this.addElement(element);
            }
        }
        catch (DuplicateNameException ex) {
            Logger.getLogger(Competence.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            throw new FubarException(ex);
        }
    }

    public void addElement(CompetenceElement element) throws DuplicateNameException {
        assert (element.getParent() == null);
        if (Competence.isUsedName(element.getName(), this.elementsUm)) {
            throw new DuplicateNameException("Competence " + this.name + " already has element with name " + element.getName());
        }
        this.elements.add(element);
        element.setParent(this);
        this.emitChildNode(element);
    }

    public String toString() {
        String ret = "\t(C " + this.name;
        if (!this.params.isEmpty()) {
            ret = ret + " vars(" + this.params.toString() + ")";
        }
        ret = ret + "\n\t\t(elements";
        for (CompetenceElement element : this.elements) {
            ret = ret + "\n\t\t\t((" + element.toString() + "))";
        }
        return ret + "\n\t\t)\n\t)";
    }

    public List<CompetenceElement> getChildDataNodes() {
        return this.elementsUm;
    }

    public void setName(String name) throws DuplicateNameException, CycleException, InvalidNameException {
        PoshPlan plan = this.getRootNode();
        if (!(name = name.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw new InvalidNameException("Name " + name + " is not valid.");
        }
        if (!this.name.equals(name) && plan != null && !plan.isUniqueAPorComp(name)) {
            throw new DuplicateNameException("New name for competence '" + this.name + "'(" + name + ") is not unique for reaction plan.");
        }
        String oldName = this.name;
        this.name = name;
        if (plan != null && plan.isCycled()) {
            this.name = oldName;
            throw new CycleException("New name (" + name + ") for competence '" + this.name + "' is causing cycle.");
        }
        this.firePropertyChange(cnName, oldName, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return this.moveNodeInList(this.elements, child, relativePosition);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement element) throws DuplicateNameException {
        if (!(element instanceof CompetenceElement)) {
            throw new UnexpectedElementException("Class " + element.getClass().getSimpleName() + " not accepted.");
        }
        this.addElement((CompetenceElement)element);
    }

    @Override
    public void neutralizeChild(PoshElement child) {
        if (this.elements.contains(child)) {
            if (this.elements.size() == 1) {
                String unusedName = Competence.getUnusedName("choice-", this.elementsUm);
                try {
                    this.addElement(CompetenceElement.create(unusedName));
                }
                catch (DuplicateNameException ex) {
                    String msg = "Unused name " + unusedName + " is not unused.";
                    Logger.getLogger(Competence.class.getName()).log(Level.SEVERE, msg, ex);
                    throw new FubarException(msg, ex);
                }
            }
        } else {
            throw new UnexpectedElementException("Not expecting " + child.toString());
        }
        this.elements.remove(child);
        child.remove();
    }

    @Override
    public int compareTo(Competence o) {
        return this.toString().compareTo(o.toString());
    }

    public FormalParameters getParameters() {
        return this.params;
    }
}

