package cz.cuni.amis.pogamut.sposh.executor;

/**
 * Extends {@link IWorkExecutor} adding methods {@link ILogicWorkExecutor#logicBeforePlan()} and {@link ILogicWorkdExecutor#logicAfterPlan()} that can be used for slipping code that should be executed
 * every logic-evaluation iteration.
 * @author Jimmy
 *
 */
public interface ILogicWorkExecutor extends IWorkExecutor {
	
	/**
	 * Method that is triggered every time the plan for executor is evaluated. It is triggered right before the plan evaluation. 
	 */
	public void logicBeforePlan();
	
	/**
	 * Method that is triggered every time the plan for executor is evaluated. It is triggered right after the plan evaluation. 
	 */
	public void logicAfterPlan();

}
