package cz.cuni.amis.pogamut.sposh.executor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Optional, use this annotation for the some implementation of {@link ISense} and
 * {@link IAction}, this annotation specifies the name and description of primitive.
 * 
 * If not specified, nothing horrible will happen, but it is not user friendly,
 * because the name of the implementing class will be used. Try to keep it unique, not
 * required, only better for humans working with editor.
 * @author Honza
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface PrimitiveInfo {
    String name();
    String description();
    String[] tags() default {};
}