package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

/**
 * This class is responsible for executing the valid posh plan.
 * 
 * @author Honza
 */
public class PoshEngine {

    public enum EvaluationResult {
        GOAL_SATISFIED,
        ELEMENT_FIRED,
        NO_ELEMENT_FIRED
    }
    
    public static class EvaluationResultInfo {
    	
    	public EvaluationResult result;
    	public FireResult.Type type;
    	
    	public EvaluationResultInfo(EvaluationResult result, FireResult.Type type) {
    		this.result = result;
    		this.type = type;
    	}
    	
    }

    protected PoshPlan plan;
    protected ITimer timer;
    protected Logger log;
    private DCExecutor dcExecutor;

    public PoshEngine(PoshPlan plan) {
        this(plan, new SystemClockTimer());
    }

    public PoshEngine(PoshPlan plan, ITimer timer) {
        this(plan, timer, null);
    }

    public PoshEngine(PoshPlan plan, ITimer timer, Logger log) {
        this.plan = plan;
        this.timer = timer;
        this.log = log;
        reset();
    }

    /**
     * Reset the posh engine, all stacks and variables will be reseted.
     * Use this to return engine to former state, it had when first initialized.
     */
    public final synchronized void reset() {
        dcExecutor = new DCExecutor(plan, new VariableContext(), timer, log);
    }

    public synchronized EvaluationResultInfo evaluatePlan(IWorkExecutor workExecuter) {
        return dcExecutor.fire(workExecuter);
    }

    ElementStackTrace getStackForDE(String name) {
        return dcExecutor.getStackForDE(name);
    }

    
    ElementStackTrace getStackForDE(int index) {
        return dcExecutor.getStackForDE(index);
    }
    
    public Logger getLog() {
    	return log;
    }
}
