package cz.cuni.amis.pogamut.sposh.engine;

/**
 * Result of ElementExecutor s. Only FOLLOW requires specification of nextElement.
 * @author Honza
 */
public final class FireResult {
    public enum Type {
        /**
         * The element is finished and result is success.
         */
        FULFILLED,
        /**
         * The element is finished and it failed.
         */
        FAILED,
        /**
         * Element wasn't yet finished.
         */
        CONTINUE,
        /**
         * Some child element is supposed to be evaluated.
         */
        FOLLOW,
        /**
         * Well, not many will use this I suppose, but move up in the stack,
         * something like return from function.
         */
        SURFACE,
    }
    
    private Type type;
    private ElementStackTrace.StackElement nextElement;

    protected FireResult(Type type) {
        this(type, null);
    }

    protected FireResult(Type type, ElementStackTrace.StackElement nextElement) {
        this.type = type;
        this.nextElement = nextElement;
    }

    /**
     * @return the continueExecution
     */
    public Type getType() {
        return type;
    }

    /**
     * @return the nextElement
     */
    public ElementStackTrace.StackElement getNextElement() {
        assert (nextElement != null) : "NextElement is null, type of FireResult should be such, that we never ask for it (is "+ getType() +")";
        return nextElement;
    }
}
