package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Freq.FreqUnits;
import java.util.ArrayList;
import java.util.List;
import java.awt.datatransfer.DataFlavor;

/**
 * One element of Drive.
 * In posh it has this syntax:
 *  (<name> [<trigger>] <name> [<freq>] [<comment>])
 *
 * @author Honza
 */
public class DriveElement extends PoshDummyElement {

	private String _name;
	private Triggers _triggers;
	private TriggeredAction _action;
	private Freq _freq;
        private String comment;

	/**
	 * Create a new DriveElement
	 * 
	 * @param name name of  drive element
	 * @param triggers all trigge
	 * @param actionName
	 * @param freq might be null XXX: what to do, if no frequency was given
	 */
	public DriveElement(String name, Triggers triggers, String actionName, Freq freq) {
            this(name, triggers, actionName, freq, null);
	}

        public DriveElement(String name, Triggers triggers, String actionName, Freq freq, String comment) {
            this(name, triggers, new Sense.SenseCall(actionName), freq, comment);
        }


        public DriveElement(String name, Triggers triggers, Sense.SenseCall actionCall, Freq freq, String comment) {
            this._name = name;
            this._triggers = triggers;
            this._action = new TriggeredAction(actionCall);
            this._freq = freq;
            if (this._freq == null) {
                this._freq = new Freq();
            }

            _action.setParent(this);
            _triggers.setParent(this);
            this.comment = comment;
        }

            
        public Triggers getTriggers() {
		return _triggers;
	}
	
	public TriggeredAction getTriggeredAction() {
		return _action;
	}

	/**
	 * Set new triggered action, delete old if necessary
	 * @param action
	 */
	public void setTriggeredAction(TriggeredAction action) {
                _action.remove();
		_action = action;
		_action.setParent(this);
		emitChildNode(_action);
	}

	@Override
	public String toString() {
                String res;

                if (_triggers.getChildDataNodes().size() == 0) {
                    res = "(" + _name + " " + _action.toString();
                } else {
                    res = "(" + _name + " (trigger " + _triggers.toString() + ") " + _action.toString();
                }
		if (_freq != null) {
			res += " " + _freq.toString();
		}

                if (comment != null) {
			res += " \"" + comment + "\"";
		}

                return res + ")";
	}

	@Override
	public List<PoshElement> getChildDataNodes() {
		List<PoshElement> children = new ArrayList<PoshElement>();
		children.add(_triggers);
		children.add(_action);

		return children;
	}
	
	public static final String deName = "deName";
	public static final String deFreqNum = "deFreqNum";
	public static final String deFreqUnits = "deFreqUnits";
	public static final String deComment = "deComment";

        public String getComment() {
            return comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

	public String getDriveName() {
		return _name;
	}

	/**
	 * Set name of the drive if it maches IDENT_PATTERN. If new name doesn't
	 * match IDENT_PATTERN, name won't be changed.
	 *
	 * @param name text
	 */
	public void setDriveName(String name) {
		name = name.trim();
		if (name.matches(IDENT_PATTERN)) {
			this._name = name;
			firePropertyChange(deName, null, name);
		}
	}

        /**
         * Return copy of freq of this DriveElement.
         * @return
         */
        public Freq getFreq() {
            return new Freq(_freq);
        }

	public Double getFreqNum() {
		return new Double(_freq.getAmmount());
	}

	/**
	 * Setting frequency has two parts number + type of unit,
	 * this one changes number of frequency.
	 *
	 * @param newNum
	 */
	public void setFreqNum(Double newNum) {
		if (newNum != null) {
			_freq.setAmmount(newNum);
			this.firePropertyChange(deFreqNum, null, newNum);
		}
	}

	public Integer getFreqUnits() {
		return _freq.getUnits().getId();
	}

	/**
	 * Setting frequency has two parts number + type of unit,
	 * this one changes type of units of frequency.
	 *
	 * @param newUnitsId getId() of enum FreqUnits.
	 */
	public void setFreqUnits(Integer newUnitsId) {
		
		if (newUnitsId != null) {
			for (FreqUnits unit : FreqUnits.values()) {
				if (unit.getId() == newUnitsId) {
					_freq.setUnits(unit);
					firePropertyChange(deFreqUnits, null, unit);
				}
			}
		}
	}

	@Override
	public String getDisplayName() {
		return getDriveName();
	}

	@Override
	public boolean moveChild(PoshElement child, int relativePosition) {
		return false;
	}

	public static final DataFlavor dataFlavor = new DataFlavor(DriveElement.class, "drive-element"); 
	
	@Override
	public DataFlavor getDataFlavor() {
		return dataFlavor;
	}

	@Override
	public void addChildDataNode(PoshElement newChild) {
		// fixme: maybe accept even triggers?
		if (newChild instanceof TriggeredAction) {
			this.setTriggeredAction((TriggeredAction) newChild);
		} else { 
			throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
		}
	}

	/**
	 * Set triggers, first clear the original triggers and than replace them with
	 * new ones. Assign parents and emit children.
	 * @param newTriggers
	 */
	private void setTriggers(Triggers newTriggers) {
                newTriggers.setParent(this);
		this._triggers.remove();
		this._triggers = newTriggers;

                emitChildNode(this._triggers);
	}

	@Override
	public void neutralizeChild(PoshElement childNode) {
		if (this._action == childNode) {
			this.setTriggeredAction(new TriggeredAction("do_nothing"));
		} else if (this._triggers == childNode) {
			this.setTriggers(new Triggers(new Sense("succeed")));
		}
	}
	
}
