/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class CallParameters
extends AbstractList<Parameter> {
    private List<Parameter> parameters = new ArrayList<Parameter>();

    protected CallParameters() {
    }

    protected CallParameters(CallParameters parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            this.parameters.add(parameters.get(i));
        }
    }

    @Override
    public synchronized Parameter get(int index) {
        return this.parameters.get(index);
    }

    @Override
    public synchronized int size() {
        return this.parameters.size();
    }

    public synchronized boolean addFormal(Parameter element, FormalParameters formalParams) {
        String parameterVariable = element.getParameterVariable();
        if (parameterVariable != null && !formalParams.containsVariable(parameterVariable)) {
            throw new IllegalArgumentException("Variable \"" + parameterVariable + "\" is not defined in formal parameters (" + formalParams.toString() + ").");
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            String parameterName = this.parameters.get(i).getParameterName();
            if (parameterName == null || !parameterName.equals(element.getParameterName())) continue;
            throw new IllegalArgumentException("Named parameter \"" + element.getParameterName() + "\" has already been defined.");
        }
        return this.parameters.add(element);
    }

    protected static final class ValueParameter
    extends Parameter {
        private final Object value;

        protected ValueParameter(int sequenceNumber, Object value) {
            super(Integer.toString(sequenceNumber));
            this.value = value;
        }

        protected ValueParameter(String parameterName, Object value) {
            super(parameterName);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getParameterVariable() {
            return null;
        }
    }

    protected static class VariableParemeter
    extends Parameter {
        protected final String variableName;

        protected VariableParemeter(int index, String variableName) {
            super(Integer.toString(index));
            this.variableName = variableName;
        }

        protected VariableParemeter(String parameterName, String variableName) {
            super(parameterName);
            this.variableName = variableName;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        @Override
        public String getParameterVariable() {
            return this.variableName;
        }
    }

    public static abstract class Parameter {
        private final String parameterName;

        protected Parameter(String parameterName) {
            this.parameterName = parameterName;
        }

        public abstract Object getValue();

        public abstract String getParameterVariable();

        public String getParameterName() {
            return this.parameterName;
        }
    }
}

